/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CredentialSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CredentialSummary> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CredentialSummary.getter(CredentialSummary::enabled)).setter(CredentialSummary.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Boolean> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("failed").getter(CredentialSummary.getter(CredentialSummary::failed)).setter(CredentialSummary.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(CredentialSummary.getter(CredentialSummary::issuer)).setter(CredentialSummary.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<Instant> SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("seenAt").getter(CredentialSummary.getter(CredentialSummary::seenAt)).setter(CredentialSummary.setter(Builder::seenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seenAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serialNumber").getter(CredentialSummary.getter(CredentialSummary::serialNumber)).setter(CredentialSummary.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<String> X509_CERTIFICATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("x509CertificateData").getter(CredentialSummary.getter(CredentialSummary::x509CertificateData)).setter(CredentialSummary.setter(Builder::x509CertificateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509CertificateData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, FAILED_FIELD, ISSUER_FIELD, SEEN_AT_FIELD, SERIAL_NUMBER_FIELD, X509_CERTIFICATE_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CredentialSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean failed;
    private final String issuer;
    private final Instant seenAt;
    private final String serialNumber;
    private final String x509CertificateData;

    private CredentialSummary(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.failed = builder.failed;
        this.issuer = builder.issuer;
        this.seenAt = builder.seenAt;
        this.serialNumber = builder.serialNumber;
        this.x509CertificateData = builder.x509CertificateData;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean failed() {
        return this.failed;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final Instant seenAt() {
        return this.seenAt;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String x509CertificateData() {
        return this.x509CertificateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.seenAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.x509CertificateData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialSummary)) {
            return false;
        }
        CredentialSummary other = (CredentialSummary)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.failed(), other.failed()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.seenAt(), other.seenAt()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.x509CertificateData(), other.x509CertificateData());
    }

    public final String toString() {
        return ToString.builder((String)"CredentialSummary").add("Enabled", (Object)this.enabled()).add("Failed", (Object)this.failed()).add("Issuer", (Object)this.issuer()).add("SeenAt", (Object)this.seenAt()).add("SerialNumber", (Object)this.serialNumber()).add("X509CertificateData", (Object)this.x509CertificateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "seenAt": {
                return Optional.ofNullable(clazz.cast(this.seenAt()));
            }
            case "serialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "x509CertificateData": {
                return Optional.ofNullable(clazz.cast(this.x509CertificateData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("failed", FAILED_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("seenAt", SEEN_AT_FIELD);
        map.put("serialNumber", SERIAL_NUMBER_FIELD);
        map.put("x509CertificateData", X509_CERTIFICATE_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialSummary, T> g) {
        return obj -> g.apply((CredentialSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean failed;
        private String issuer;
        private Instant seenAt;
        private String serialNumber;
        private String x509CertificateData;

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialSummary model) {
            this.enabled(model.enabled);
            this.failed(model.failed);
            this.issuer(model.issuer);
            this.seenAt(model.seenAt);
            this.serialNumber(model.serialNumber);
            this.x509CertificateData(model.x509CertificateData);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getFailed() {
            return this.failed;
        }

        public final void setFailed(Boolean failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Boolean failed) {
            this.failed = failed;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final Instant getSeenAt() {
            return this.seenAt;
        }

        public final void setSeenAt(Instant seenAt) {
            this.seenAt = seenAt;
        }

        @Override
        public final Builder seenAt(Instant seenAt) {
            this.seenAt = seenAt;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getX509CertificateData() {
            return this.x509CertificateData;
        }

        public final void setX509CertificateData(String x509CertificateData) {
            this.x509CertificateData = x509CertificateData;
        }

        @Override
        public final Builder x509CertificateData(String x509CertificateData) {
            this.x509CertificateData = x509CertificateData;
            return this;
        }

        public CredentialSummary build() {
            return new CredentialSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CredentialSummary> {
        public Builder enabled(Boolean var1);

        public Builder failed(Boolean var1);

        public Builder issuer(String var1);

        public Builder seenAt(Instant var1);

        public Builder serialNumber(String var1);

        public Builder x509CertificateData(String var1);
    }
}

