/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereAsyncClient;
import software.amazon.awssdk.services.rolesanywhere.internal.UserAgentUtils;
import software.amazon.awssdk.services.rolesanywhere.model.CrlDetail;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse;

public class ListCrlsPublisher
implements SdkPublisher<ListCrlsResponse> {
    private final RolesAnywhereAsyncClient client;
    private final ListCrlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCrlsPublisher(RolesAnywhereAsyncClient client, ListCrlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCrlsPublisher(RolesAnywhereAsyncClient client, ListCrlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCrlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCrlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CrlDetail> crls() {
        Function<ListCrlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crls() != null) {
                return response.crls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCrlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCrlsResponseFetcher
    implements AsyncPageFetcher<ListCrlsResponse> {
        private ListCrlsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCrlsResponse> nextPage(ListCrlsResponse previousPage) {
            if (previousPage == null) {
                return ListCrlsPublisher.this.client.listCrls(ListCrlsPublisher.this.firstRequest);
            }
            return ListCrlsPublisher.this.client.listCrls((ListCrlsRequest)((Object)ListCrlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

