/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereResponse;
import software.amazon.awssdk.services.rolesanywhere.model.TrustAnchorDetail;
import software.amazon.awssdk.services.rolesanywhere.model.TrustAnchorDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustAnchorsResponse
extends RolesAnywhereResponse
implements ToCopyableBuilder<Builder, ListTrustAnchorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrustAnchorsResponse.getter(ListTrustAnchorsResponse::nextToken)).setter(ListTrustAnchorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TrustAnchorDetail>> TRUST_ANCHORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trustAnchors").getter(ListTrustAnchorsResponse.getter(ListTrustAnchorsResponse::trustAnchors)).setter(ListTrustAnchorsResponse.setter(Builder::trustAnchors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustAnchorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRUST_ANCHORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("trustAnchors", TRUST_ANCHORS_FIELD);
        }
    });
    private final String nextToken;
    private final List<TrustAnchorDetail> trustAnchors;

    private ListTrustAnchorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trustAnchors = builder.trustAnchors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrustAnchors() {
        return this.trustAnchors != null && !(this.trustAnchors instanceof SdkAutoConstructList);
    }

    public final List<TrustAnchorDetail> trustAnchors() {
        return this.trustAnchors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustAnchors() ? this.trustAnchors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustAnchorsResponse)) {
            return false;
        }
        ListTrustAnchorsResponse other = (ListTrustAnchorsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrustAnchors() == other.hasTrustAnchors() && Objects.equals(this.trustAnchors(), other.trustAnchors());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustAnchorsResponse").add("NextToken", (Object)this.nextToken()).add("TrustAnchors", this.hasTrustAnchors() ? this.trustAnchors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "trustAnchors": {
                return Optional.ofNullable(clazz.cast(this.trustAnchors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTrustAnchorsResponse, T> g) {
        return obj -> g.apply((ListTrustAnchorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrustAnchorDetail> trustAnchors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustAnchorsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trustAnchors(model.trustAnchors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrustAnchorDetail.Builder> getTrustAnchors() {
            List<TrustAnchorDetail.Builder> result = TrustAnchorDetailsCopier.copyToBuilder(this.trustAnchors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustAnchors(Collection<TrustAnchorDetail.BuilderImpl> trustAnchors) {
            this.trustAnchors = TrustAnchorDetailsCopier.copyFromBuilder(trustAnchors);
        }

        @Override
        public final Builder trustAnchors(Collection<TrustAnchorDetail> trustAnchors) {
            this.trustAnchors = TrustAnchorDetailsCopier.copy(trustAnchors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustAnchors(TrustAnchorDetail ... trustAnchors) {
            this.trustAnchors(Arrays.asList(trustAnchors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustAnchors(Consumer<TrustAnchorDetail.Builder> ... trustAnchors) {
            this.trustAnchors(Stream.of(trustAnchors).map(c -> (TrustAnchorDetail)((TrustAnchorDetail.Builder)TrustAnchorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustAnchorsResponse build() {
            return new ListTrustAnchorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RolesAnywhereResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustAnchorsResponse> {
        public Builder nextToken(String var1);

        public Builder trustAnchors(Collection<TrustAnchorDetail> var1);

        public Builder trustAnchors(TrustAnchorDetail ... var1);

        public Builder trustAnchors(Consumer<TrustAnchorDetail.Builder> ... var1);
    }
}

