/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereAsyncClient;
import software.amazon.awssdk.services.rolesanywhere.internal.UserAgentUtils;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.TrustAnchorDetail;

public class ListTrustAnchorsPublisher
implements SdkPublisher<ListTrustAnchorsResponse> {
    private final RolesAnywhereAsyncClient client;
    private final ListTrustAnchorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrustAnchorsPublisher(RolesAnywhereAsyncClient client, ListTrustAnchorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrustAnchorsPublisher(RolesAnywhereAsyncClient client, ListTrustAnchorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrustAnchorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrustAnchorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrustAnchorDetail> trustAnchors() {
        Function<ListTrustAnchorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustAnchors() != null) {
                return response.trustAnchors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrustAnchorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrustAnchorsResponseFetcher
    implements AsyncPageFetcher<ListTrustAnchorsResponse> {
        private ListTrustAnchorsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustAnchorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrustAnchorsResponse> nextPage(ListTrustAnchorsResponse previousPage) {
            if (previousPage == null) {
                return ListTrustAnchorsPublisher.this.client.listTrustAnchors(ListTrustAnchorsPublisher.this.firstRequest);
            }
            return ListTrustAnchorsPublisher.this.client.listTrustAnchors((ListTrustAnchorsRequest)((Object)ListTrustAnchorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

