/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CertificateField {
    X509_SUBJECT("x509Subject"),
    X509_ISSUER("x509Issuer"),
    X509_SAN("x509SAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CertificateField> VALUE_MAP;
    private final String value;

    private CertificateField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CertificateField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CertificateField> knownValues() {
        EnumSet<CertificateField> knownValues = EnumSet.allOf(CertificateField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CertificateField.class, CertificateField::toString);
    }
}

