/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceData> {
    private static final SdkField<String> ACM_PCA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acmPcaArn").getter(SourceData.getter(SourceData::acmPcaArn)).setter(SourceData.setter(Builder::acmPcaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acmPcaArn").build()}).build();
    private static final SdkField<String> X509_CERTIFICATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("x509CertificateData").getter(SourceData.getter(SourceData::x509CertificateData)).setter(SourceData.setter(Builder::x509CertificateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x509CertificateData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_PCA_ARN_FIELD, X509_CERTIFICATE_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String acmPcaArn;
    private final String x509CertificateData;
    private final Type type;

    private SourceData(BuilderImpl builder) {
        this.acmPcaArn = builder.acmPcaArn;
        this.x509CertificateData = builder.x509CertificateData;
        this.type = builder.type;
    }

    public final String acmPcaArn() {
        return this.acmPcaArn;
    }

    public final String x509CertificateData() {
        return this.x509CertificateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acmPcaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.x509CertificateData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceData)) {
            return false;
        }
        SourceData other = (SourceData)obj;
        return Objects.equals(this.acmPcaArn(), other.acmPcaArn()) && Objects.equals(this.x509CertificateData(), other.x509CertificateData());
    }

    public final String toString() {
        return ToString.builder((String)"SourceData").add("AcmPcaArn", (Object)this.acmPcaArn()).add("X509CertificateData", (Object)this.x509CertificateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acmPcaArn": {
                return Optional.ofNullable(clazz.cast(this.acmPcaArn()));
            }
            case "x509CertificateData": {
                return Optional.ofNullable(clazz.cast(this.x509CertificateData()));
            }
        }
        return Optional.empty();
    }

    public static SourceData fromAcmPcaArn(String acmPcaArn) {
        return (SourceData)SourceData.builder().acmPcaArn(acmPcaArn).build();
    }

    public static SourceData fromX509CertificateData(String x509CertificateData) {
        return (SourceData)SourceData.builder().x509CertificateData(x509CertificateData).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceData, T> g) {
        return obj -> g.apply((SourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACM_PCA_ARN,
        X509_CERTIFICATE_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String acmPcaArn;
        private String x509CertificateData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceData model) {
            this.acmPcaArn(model.acmPcaArn);
            this.x509CertificateData(model.x509CertificateData);
        }

        public final String getAcmPcaArn() {
            return this.acmPcaArn;
        }

        public final void setAcmPcaArn(String acmPcaArn) {
            String oldValue = this.acmPcaArn;
            this.acmPcaArn = acmPcaArn;
            this.handleUnionValueChange(Type.ACM_PCA_ARN, oldValue, this.acmPcaArn);
        }

        @Override
        public final Builder acmPcaArn(String acmPcaArn) {
            String oldValue = this.acmPcaArn;
            this.acmPcaArn = acmPcaArn;
            this.handleUnionValueChange(Type.ACM_PCA_ARN, oldValue, this.acmPcaArn);
            return this;
        }

        public final String getX509CertificateData() {
            return this.x509CertificateData;
        }

        public final void setX509CertificateData(String x509CertificateData) {
            String oldValue = this.x509CertificateData;
            this.x509CertificateData = x509CertificateData;
            this.handleUnionValueChange(Type.X509_CERTIFICATE_DATA, oldValue, this.x509CertificateData);
        }

        @Override
        public final Builder x509CertificateData(String x509CertificateData) {
            String oldValue = this.x509CertificateData;
            this.x509CertificateData = x509CertificateData;
            this.handleUnionValueChange(Type.X509_CERTIFICATE_DATA, oldValue, this.x509CertificateData);
            return this;
        }

        public SourceData build() {
            return new SourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceData> {
        public Builder acmPcaArn(String var1);

        public Builder x509CertificateData(String var1);
    }
}

