/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.DataSourceNamesCopier;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationNamesCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationNamesCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJobSummary.getter(SimulationJobSummary::arn)).setter(SimulationJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SimulationJobSummary.getter(SimulationJobSummary::lastUpdatedAt)).setter(SimulationJobSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJobSummary.getter(SimulationJobSummary::name)).setter(SimulationJobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJobSummary.getter(SimulationJobSummary::statusAsString)).setter(SimulationJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> SIMULATION_APPLICATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobSummary.getter(SimulationJobSummary::simulationApplicationNames)).setter(SimulationJobSummary.setter(Builder::simulationApplicationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplicationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROBOT_APPLICATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobSummary.getter(SimulationJobSummary::robotApplicationNames)).setter(SimulationJobSummary.setter(Builder::robotApplicationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplicationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_SOURCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobSummary.getter(SimulationJobSummary::dataSourceNames)).setter(SimulationJobSummary.setter(Builder::dataSourceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD, SIMULATION_APPLICATION_NAMES_FIELD, ROBOT_APPLICATION_NAMES_FIELD, DATA_SOURCE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final List<String> simulationApplicationNames;
    private final List<String> robotApplicationNames;
    private final List<String> dataSourceNames;

    private SimulationJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.simulationApplicationNames = builder.simulationApplicationNames;
        this.robotApplicationNames = builder.robotApplicationNames;
        this.dataSourceNames = builder.dataSourceNames;
    }

    public String arn() {
        return this.arn;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public SimulationJobStatus status() {
        return SimulationJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<String> simulationApplicationNames() {
        return this.simulationApplicationNames;
    }

    public List<String> robotApplicationNames() {
        return this.robotApplicationNames;
    }

    public List<String> dataSourceNames() {
        return this.dataSourceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationApplicationNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotApplicationNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobSummary)) {
            return false;
        }
        SimulationJobSummary other = (SimulationJobSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.simulationApplicationNames(), other.simulationApplicationNames()) && Objects.equals(this.robotApplicationNames(), other.robotApplicationNames()) && Objects.equals(this.dataSourceNames(), other.dataSourceNames());
    }

    public String toString() {
        return ToString.builder((String)"SimulationJobSummary").add("Arn", (Object)this.arn()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("SimulationApplicationNames", this.simulationApplicationNames()).add("RobotApplicationNames", this.robotApplicationNames()).add("DataSourceNames", this.dataSourceNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "simulationApplicationNames": {
                return Optional.ofNullable(clazz.cast(this.simulationApplicationNames()));
            }
            case "robotApplicationNames": {
                return Optional.ofNullable(clazz.cast(this.robotApplicationNames()));
            }
            case "dataSourceNames": {
                return Optional.ofNullable(clazz.cast(this.dataSourceNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobSummary, T> g) {
        return obj -> g.apply((SimulationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private List<String> simulationApplicationNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> robotApplicationNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataSourceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobSummary model) {
            this.arn(model.arn);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
            this.simulationApplicationNames(model.simulationApplicationNames);
            this.robotApplicationNames(model.robotApplicationNames);
            this.dataSourceNames(model.dataSourceNames);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getSimulationApplicationNames() {
            return this.simulationApplicationNames;
        }

        @Override
        public final Builder simulationApplicationNames(Collection<String> simulationApplicationNames) {
            this.simulationApplicationNames = SimulationApplicationNamesCopier.copy(simulationApplicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplicationNames(String ... simulationApplicationNames) {
            this.simulationApplicationNames(Arrays.asList(simulationApplicationNames));
            return this;
        }

        public final void setSimulationApplicationNames(Collection<String> simulationApplicationNames) {
            this.simulationApplicationNames = SimulationApplicationNamesCopier.copy(simulationApplicationNames);
        }

        public final Collection<String> getRobotApplicationNames() {
            return this.robotApplicationNames;
        }

        @Override
        public final Builder robotApplicationNames(Collection<String> robotApplicationNames) {
            this.robotApplicationNames = RobotApplicationNamesCopier.copy(robotApplicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplicationNames(String ... robotApplicationNames) {
            this.robotApplicationNames(Arrays.asList(robotApplicationNames));
            return this;
        }

        public final void setRobotApplicationNames(Collection<String> robotApplicationNames) {
            this.robotApplicationNames = RobotApplicationNamesCopier.copy(robotApplicationNames);
        }

        public final Collection<String> getDataSourceNames() {
            return this.dataSourceNames;
        }

        @Override
        public final Builder dataSourceNames(Collection<String> dataSourceNames) {
            this.dataSourceNames = DataSourceNamesCopier.copy(dataSourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceNames(String ... dataSourceNames) {
            this.dataSourceNames(Arrays.asList(dataSourceNames));
            return this;
        }

        public final void setDataSourceNames(Collection<String> dataSourceNames) {
            this.dataSourceNames = DataSourceNamesCopier.copy(dataSourceNames);
        }

        public SimulationJobSummary build() {
            return new SimulationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationJobSummary> {
        public Builder arn(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SimulationJobStatus var1);

        public Builder simulationApplicationNames(Collection<String> var1);

        public Builder simulationApplicationNames(String ... var1);

        public Builder robotApplicationNames(Collection<String> var1);

        public Builder robotApplicationNames(String ... var1);

        public Builder dataSourceNames(Collection<String> var1);

        public Builder dataSourceNames(String ... var1);
    }
}

