/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary;

public class ListWorldExportJobsIterable
implements SdkIterable<ListWorldExportJobsResponse> {
    private final RoboMakerClient client;
    private final ListWorldExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorldExportJobsIterable(RoboMakerClient client, ListWorldExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorldExportJobsResponseFetcher();
    }

    public Iterator<ListWorldExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorldExportJobSummary> worldExportJobSummaries() {
        Function<ListWorldExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldExportJobSummaries() != null) {
                return response.worldExportJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorldExportJobsResponseFetcher
    implements SyncPageFetcher<ListWorldExportJobsResponse> {
        private ListWorldExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorldExportJobsResponse nextPage(ListWorldExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldExportJobsIterable.this.client.listWorldExportJobs(ListWorldExportJobsIterable.this.firstRequest);
            }
            return ListWorldExportJobsIterable.this.client.listWorldExportJobs((ListWorldExportJobsRequest)((Object)ListWorldExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

