/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.ComputeResponse;
import software.amazon.awssdk.services.robomaker.model.DataSource;
import software.amazon.awssdk.services.robomaker.model.DataSourcesCopier;
import software.amazon.awssdk.services.robomaker.model.FailureBehavior;
import software.amazon.awssdk.services.robomaker.model.LoggingConfig;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.SimulationJobStatus;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.VPCConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSimulationJobResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, CreateSimulationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::arn)).setter(CreateSimulationJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::statusAsString)).setter(CreateSimulationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartedAt").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::lastStartedAt)).setter(CreateSimulationJobResponse.setter(Builder::lastStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::lastUpdatedAt)).setter(CreateSimulationJobResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureBehavior").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::failureBehaviorAsString)).setter(CreateSimulationJobResponse.setter(Builder::failureBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::failureCodeAsString)).setter(CreateSimulationJobResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::clientRequestToken)).setter(CreateSimulationJobResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::outputLocation)).setter(CreateSimulationJobResponse.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfig").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::loggingConfig)).setter(CreateSimulationJobResponse.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()}).build();
    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxJobDurationInSeconds").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::maxJobDurationInSeconds)).setter(CreateSimulationJobResponse.setter(Builder::maxJobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build()}).build();
    private static final SdkField<Long> SIMULATION_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("simulationTimeMillis").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::simulationTimeMillis)).setter(CreateSimulationJobResponse.setter(Builder::simulationTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationTimeMillis").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRole").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::iamRole)).setter(CreateSimulationJobResponse.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("robotApplications").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::robotApplications)).setter(CreateSimulationJobResponse.setter(Builder::robotApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("simulationApplications").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::simulationApplications)).setter(CreateSimulationJobResponse.setter(Builder::simulationApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSources").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::dataSources)).setter(CreateSimulationJobResponse.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::tags)).setter(CreateSimulationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VPCConfigResponse> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::vpcConfig)).setter(CreateSimulationJobResponse.setter(Builder::vpcConfig)).constructor(VPCConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<ComputeResponse> COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compute").getter(CreateSimulationJobResponse.getter(CreateSimulationJobResponse::compute)).setter(CreateSimulationJobResponse.setter(Builder::compute)).constructor(ComputeResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, LAST_STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_BEHAVIOR_FIELD, FAILURE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, OUTPUT_LOCATION_FIELD, LOGGING_CONFIG_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, SIMULATION_TIME_MILLIS_FIELD, IAM_ROLE_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, COMPUTE_FIELD));
    private final String arn;
    private final String status;
    private final Instant lastStartedAt;
    private final Instant lastUpdatedAt;
    private final String failureBehavior;
    private final String failureCode;
    private final String clientRequestToken;
    private final OutputLocation outputLocation;
    private final LoggingConfig loggingConfig;
    private final Long maxJobDurationInSeconds;
    private final Long simulationTimeMillis;
    private final String iamRole;
    private final List<RobotApplicationConfig> robotApplications;
    private final List<SimulationApplicationConfig> simulationApplications;
    private final List<DataSource> dataSources;
    private final Map<String, String> tags;
    private final VPCConfigResponse vpcConfig;
    private final ComputeResponse compute;

    private CreateSimulationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastStartedAt = builder.lastStartedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureBehavior = builder.failureBehavior;
        this.failureCode = builder.failureCode;
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.simulationTimeMillis = builder.simulationTimeMillis;
        this.iamRole = builder.iamRole;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.compute = builder.compute;
    }

    public final String arn() {
        return this.arn;
    }

    public final SimulationJobStatus status() {
        return SimulationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastStartedAt() {
        return this.lastStartedAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(this.failureBehavior);
    }

    public final String failureBehaviorAsString() {
        return this.failureBehavior;
    }

    public final SimulationJobErrorCode failureCode() {
        return SimulationJobErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final Long maxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public final Long simulationTimeMillis() {
        return this.simulationTimeMillis;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final boolean hasRobotApplications() {
        return this.robotApplications != null && !(this.robotApplications instanceof SdkAutoConstructList);
    }

    public final List<RobotApplicationConfig> robotApplications() {
        return this.robotApplications;
    }

    public final boolean hasSimulationApplications() {
        return this.simulationApplications != null && !(this.simulationApplications instanceof SdkAutoConstructList);
    }

    public final List<SimulationApplicationConfig> simulationApplications() {
        return this.simulationApplications;
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<DataSource> dataSources() {
        return this.dataSources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VPCConfigResponse vpcConfig() {
        return this.vpcConfig;
    }

    public final ComputeResponse compute() {
        return this.compute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRobotApplications() ? this.robotApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSimulationApplications() ? this.simulationApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.compute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationJobResponse)) {
            return false;
        }
        CreateSimulationJobResponse other = (CreateSimulationJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastStartedAt(), other.lastStartedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.failureBehaviorAsString(), other.failureBehaviorAsString()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.maxJobDurationInSeconds(), other.maxJobDurationInSeconds()) && Objects.equals(this.simulationTimeMillis(), other.simulationTimeMillis()) && Objects.equals(this.iamRole(), other.iamRole()) && this.hasRobotApplications() == other.hasRobotApplications() && Objects.equals(this.robotApplications(), other.robotApplications()) && this.hasSimulationApplications() == other.hasSimulationApplications() && Objects.equals(this.simulationApplications(), other.simulationApplications()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSources(), other.dataSources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.compute(), other.compute());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSimulationJobResponse").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("LastStartedAt", (Object)this.lastStartedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("FailureBehavior", (Object)this.failureBehaviorAsString()).add("FailureCode", (Object)this.failureCodeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("OutputLocation", (Object)this.outputLocation()).add("LoggingConfig", (Object)this.loggingConfig()).add("MaxJobDurationInSeconds", (Object)this.maxJobDurationInSeconds()).add("SimulationTimeMillis", (Object)this.simulationTimeMillis()).add("IamRole", (Object)this.iamRole()).add("RobotApplications", this.hasRobotApplications() ? this.robotApplications() : null).add("SimulationApplications", this.hasSimulationApplications() ? this.simulationApplications() : null).add("DataSources", this.hasDataSources() ? this.dataSources() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfig", (Object)this.vpcConfig()).add("Compute", (Object)this.compute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastStartedAt": {
                return Optional.ofNullable(clazz.cast(this.lastStartedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "failureBehavior": {
                return Optional.ofNullable(clazz.cast(this.failureBehaviorAsString()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "loggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "maxJobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxJobDurationInSeconds()));
            }
            case "simulationTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.simulationTimeMillis()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "robotApplications": {
                return Optional.ofNullable(clazz.cast(this.robotApplications()));
            }
            case "simulationApplications": {
                return Optional.ofNullable(clazz.cast(this.simulationApplications()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "compute": {
                return Optional.ofNullable(clazz.cast(this.compute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationJobResponse, T> g) {
        return obj -> g.apply((CreateSimulationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant lastStartedAt;
        private Instant lastUpdatedAt;
        private String failureBehavior;
        private String failureCode;
        private String clientRequestToken;
        private OutputLocation outputLocation;
        private LoggingConfig loggingConfig;
        private Long maxJobDurationInSeconds;
        private Long simulationTimeMillis;
        private String iamRole;
        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VPCConfigResponse vpcConfig;
        private ComputeResponse compute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.status(model.status);
            this.lastStartedAt(model.lastStartedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.failureBehavior(model.failureBehavior);
            this.failureCode(model.failureCode);
            this.clientRequestToken(model.clientRequestToken);
            this.outputLocation(model.outputLocation);
            this.loggingConfig(model.loggingConfig);
            this.maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            this.simulationTimeMillis(model.simulationTimeMillis);
            this.iamRole(model.iamRole);
            this.robotApplications(model.robotApplications);
            this.simulationApplications(model.simulationApplications);
            this.dataSources(model.dataSources);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
            this.compute(model.compute);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastStartedAt() {
            return this.lastStartedAt;
        }

        public final void setLastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
        }

        @Override
        public final Builder lastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getFailureBehavior() {
            return this.failureBehavior;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final Long getMaxJobDurationInSeconds() {
            return this.maxJobDurationInSeconds;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final Long getSimulationTimeMillis() {
            return this.simulationTimeMillis;
        }

        public final void setSimulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
        }

        @Override
        public final Builder simulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final List<RobotApplicationConfig.Builder> getRobotApplications() {
            List<RobotApplicationConfig.Builder> result = RobotApplicationConfigsCopier.copyToBuilder(this.robotApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig ... robotApplications) {
            this.robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... robotApplications) {
            this.robotApplications(Stream.of(robotApplications).map(c -> (RobotApplicationConfig)((RobotApplicationConfig.Builder)RobotApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SimulationApplicationConfig.Builder> getSimulationApplications() {
            List<SimulationApplicationConfig.Builder> result = SimulationApplicationConfigsCopier.copyToBuilder(this.simulationApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig ... simulationApplications) {
            this.simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... simulationApplications) {
            this.simulationApplications(Stream.of(simulationApplications).map(c -> (SimulationApplicationConfig)((SimulationApplicationConfig.Builder)SimulationApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VPCConfigResponse.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VPCConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ComputeResponse.Builder getCompute() {
            return this.compute != null ? this.compute.toBuilder() : null;
        }

        public final void setCompute(ComputeResponse.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        @Override
        public final Builder compute(ComputeResponse compute) {
            this.compute = compute;
            return this;
        }

        @Override
        public CreateSimulationJobResponse build() {
            return new CreateSimulationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSimulationJobResponse> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(SimulationJobStatus var1);

        public Builder lastStartedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder failureBehavior(String var1);

        public Builder failureBehavior(FailureBehavior var1);

        public Builder failureCode(String var1);

        public Builder failureCode(SimulationJobErrorCode var1);

        public Builder clientRequestToken(String var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder maxJobDurationInSeconds(Long var1);

        public Builder simulationTimeMillis(Long var1);

        public Builder iamRole(String var1);

        public Builder robotApplications(Collection<RobotApplicationConfig> var1);

        public Builder robotApplications(RobotApplicationConfig ... var1);

        public Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... var1);

        public Builder simulationApplications(Collection<SimulationApplicationConfig> var1);

        public Builder simulationApplications(SimulationApplicationConfig ... var1);

        public Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcConfig(VPCConfigResponse var1);

        default public Builder vpcConfig(Consumer<VPCConfigResponse.Builder> vpcConfig) {
            return this.vpcConfig((VPCConfigResponse)((VPCConfigResponse.Builder)VPCConfigResponse.builder().applyMutation(vpcConfig)).build());
        }

        public Builder compute(ComputeResponse var1);

        default public Builder compute(Consumer<ComputeResponse.Builder> compute) {
            return this.compute((ComputeResponse)((ComputeResponse.Builder)ComputeResponse.builder().applyMutation(compute)).build());
        }
    }
}

