/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary;

public class ListWorldExportJobsPublisher
implements SdkPublisher<ListWorldExportJobsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListWorldExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorldExportJobsPublisher(RoboMakerAsyncClient client, ListWorldExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorldExportJobsPublisher(RoboMakerAsyncClient client, ListWorldExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorldExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorldExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorldExportJobSummary> worldExportJobSummaries() {
        Function<ListWorldExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldExportJobSummaries() != null) {
                return response.worldExportJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorldExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorldExportJobsResponseFetcher
    implements AsyncPageFetcher<ListWorldExportJobsResponse> {
        private ListWorldExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorldExportJobsResponse> nextPage(ListWorldExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldExportJobsPublisher.this.client.listWorldExportJobs(ListWorldExportJobsPublisher.this.firstRequest);
            }
            return ListWorldExportJobsPublisher.this.client.listWorldExportJobs((ListWorldExportJobsRequest)((Object)ListWorldExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

