/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorldGenerationJobStatus {
    PENDING("Pending"),
    RUNNING("Running"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    PARTIAL_FAILED("PartialFailed"),
    CANCELING("Canceling"),
    CANCELED("Canceled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorldGenerationJobStatus> VALUE_MAP;
    private final String value;

    private WorldGenerationJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorldGenerationJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorldGenerationJobStatus> knownValues() {
        EnumSet<WorldGenerationJobStatus> knownValues = EnumSet.allOf(WorldGenerationJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorldGenerationJobStatus.class, WorldGenerationJobStatus::toString);
    }
}

