/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of worlds that will be created. You can configure the number of unique floorplans and the number of unique
 * interiors for each floor plan. For example, if you want 1 world with 20 unique interiors, you set
 * <code>floorplanCount = 1</code> and <code>interiorCountPerFloorplan = 20</code>. This will result in 20 worlds (
 * <code>floorplanCount</code> * <code>interiorCountPerFloorplan)</code>.
 * </p>
 * <p>
 * If you set <code>floorplanCount = 4</code> and <code>interiorCountPerFloorplan = 5</code>, there will be 20 worlds
 * with 5 unique floor plans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldCount implements SdkPojo, Serializable, ToCopyableBuilder<WorldCount.Builder, WorldCount> {
    private static final SdkField<Integer> FLOORPLAN_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("floorplanCount").getter(getter(WorldCount::floorplanCount)).setter(setter(Builder::floorplanCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floorplanCount").build()).build();

    private static final SdkField<Integer> INTERIOR_COUNT_PER_FLOORPLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("interiorCountPerFloorplan")
            .getter(getter(WorldCount::interiorCountPerFloorplan)).setter(setter(Builder::interiorCountPerFloorplan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interiorCountPerFloorplan").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOORPLAN_COUNT_FIELD,
            INTERIOR_COUNT_PER_FLOORPLAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer floorplanCount;

    private final Integer interiorCountPerFloorplan;

    private WorldCount(BuilderImpl builder) {
        this.floorplanCount = builder.floorplanCount;
        this.interiorCountPerFloorplan = builder.interiorCountPerFloorplan;
    }

    /**
     * <p>
     * The number of unique floorplans.
     * </p>
     * 
     * @return The number of unique floorplans.
     */
    public final Integer floorplanCount() {
        return floorplanCount;
    }

    /**
     * <p>
     * The number of unique interiors per floorplan.
     * </p>
     * 
     * @return The number of unique interiors per floorplan.
     */
    public final Integer interiorCountPerFloorplan() {
        return interiorCountPerFloorplan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(floorplanCount());
        hashCode = 31 * hashCode + Objects.hashCode(interiorCountPerFloorplan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldCount)) {
            return false;
        }
        WorldCount other = (WorldCount) obj;
        return Objects.equals(floorplanCount(), other.floorplanCount())
                && Objects.equals(interiorCountPerFloorplan(), other.interiorCountPerFloorplan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorldCount").add("FloorplanCount", floorplanCount())
                .add("InteriorCountPerFloorplan", interiorCountPerFloorplan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "floorplanCount":
            return Optional.ofNullable(clazz.cast(floorplanCount()));
        case "interiorCountPerFloorplan":
            return Optional.ofNullable(clazz.cast(interiorCountPerFloorplan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldCount, T> g) {
        return obj -> g.apply((WorldCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldCount> {
        /**
         * <p>
         * The number of unique floorplans.
         * </p>
         * 
         * @param floorplanCount
         *        The number of unique floorplans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floorplanCount(Integer floorplanCount);

        /**
         * <p>
         * The number of unique interiors per floorplan.
         * </p>
         * 
         * @param interiorCountPerFloorplan
         *        The number of unique interiors per floorplan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interiorCountPerFloorplan(Integer interiorCountPerFloorplan);
    }

    static final class BuilderImpl implements Builder {
        private Integer floorplanCount;

        private Integer interiorCountPerFloorplan;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldCount model) {
            floorplanCount(model.floorplanCount);
            interiorCountPerFloorplan(model.interiorCountPerFloorplan);
        }

        public final Integer getFloorplanCount() {
            return floorplanCount;
        }

        @Override
        public final Builder floorplanCount(Integer floorplanCount) {
            this.floorplanCount = floorplanCount;
            return this;
        }

        public final void setFloorplanCount(Integer floorplanCount) {
            this.floorplanCount = floorplanCount;
        }

        public final Integer getInteriorCountPerFloorplan() {
            return interiorCountPerFloorplan;
        }

        @Override
        public final Builder interiorCountPerFloorplan(Integer interiorCountPerFloorplan) {
            this.interiorCountPerFloorplan = interiorCountPerFloorplan;
            return this;
        }

        public final void setInteriorCountPerFloorplan(Integer interiorCountPerFloorplan) {
            this.interiorCountPerFloorplan = interiorCountPerFloorplan;
        }

        @Override
        public WorldCount build() {
            return new WorldCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
