/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a robot deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RobotDeployment implements SdkPojo, Serializable, ToCopyableBuilder<RobotDeployment.Builder, RobotDeployment> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RobotDeployment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deploymentStartTime").getter(getter(RobotDeployment::deploymentStartTime))
            .setter(setter(Builder::deploymentStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStartTime").build())
            .build();

    private static final SdkField<Instant> DEPLOYMENT_FINISH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deploymentFinishTime").getter(getter(RobotDeployment::deploymentFinishTime))
            .setter(setter(Builder::deploymentFinishTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentFinishTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RobotDeployment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ProgressDetail> PROGRESS_DETAIL_FIELD = SdkField
            .<ProgressDetail> builder(MarshallingType.SDK_POJO).memberName("progressDetail")
            .getter(getter(RobotDeployment::progressDetail)).setter(setter(Builder::progressDetail))
            .constructor(ProgressDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressDetail").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(RobotDeployment::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(RobotDeployment::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DEPLOYMENT_START_TIME_FIELD, DEPLOYMENT_FINISH_TIME_FIELD, STATUS_FIELD, PROGRESS_DETAIL_FIELD, FAILURE_REASON_FIELD,
            FAILURE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant deploymentStartTime;

    private final Instant deploymentFinishTime;

    private final String status;

    private final ProgressDetail progressDetail;

    private final String failureReason;

    private final String failureCode;

    private RobotDeployment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deploymentStartTime = builder.deploymentStartTime;
        this.deploymentFinishTime = builder.deploymentFinishTime;
        this.status = builder.status;
        this.progressDetail = builder.progressDetail;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
    }

    /**
     * <p>
     * The robot deployment Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The robot deployment Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the deployment was started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the deployment was started.
     */
    public final Instant deploymentStartTime() {
        return deploymentStartTime;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the deployment finished.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the deployment finished.
     */
    public final Instant deploymentFinishTime() {
        return deploymentFinishTime;
    }

    /**
     * <p>
     * The status of the robot deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the robot deployment.
     * @see RobotStatus
     */
    public final RobotStatus status() {
        return RobotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the robot deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the robot deployment.
     * @see RobotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about how the deployment is progressing.
     * </p>
     * 
     * @return Information about how the deployment is progressing.
     */
    public final ProgressDetail progressDetail() {
        return progressDetail;
    }

    /**
     * <p>
     * A short description of the reason why the robot deployment failed.
     * </p>
     * 
     * @return A short description of the reason why the robot deployment failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The robot deployment failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The robot deployment failure code.
     * @see DeploymentJobErrorCode
     */
    public final DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The robot deployment failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The robot deployment failure code.
     * @see DeploymentJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentFinishTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progressDetail());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotDeployment)) {
            return false;
        }
        RobotDeployment other = (RobotDeployment) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(deploymentStartTime(), other.deploymentStartTime())
                && Objects.equals(deploymentFinishTime(), other.deploymentFinishTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(progressDetail(), other.progressDetail())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RobotDeployment").add("Arn", arn()).add("DeploymentStartTime", deploymentStartTime())
                .add("DeploymentFinishTime", deploymentFinishTime()).add("Status", statusAsString())
                .add("ProgressDetail", progressDetail()).add("FailureReason", failureReason())
                .add("FailureCode", failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "deploymentStartTime":
            return Optional.ofNullable(clazz.cast(deploymentStartTime()));
        case "deploymentFinishTime":
            return Optional.ofNullable(clazz.cast(deploymentFinishTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "progressDetail":
            return Optional.ofNullable(clazz.cast(progressDetail()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotDeployment, T> g) {
        return obj -> g.apply((RobotDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RobotDeployment> {
        /**
         * <p>
         * The robot deployment Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The robot deployment Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the deployment was started.
         * </p>
         * 
         * @param deploymentStartTime
         *        The time, in milliseconds since the epoch, when the deployment was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStartTime(Instant deploymentStartTime);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the deployment finished.
         * </p>
         * 
         * @param deploymentFinishTime
         *        The time, in milliseconds since the epoch, when the deployment finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentFinishTime(Instant deploymentFinishTime);

        /**
         * <p>
         * The status of the robot deployment.
         * </p>
         * 
         * @param status
         *        The status of the robot deployment.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the robot deployment.
         * </p>
         * 
         * @param status
         *        The status of the robot deployment.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(RobotStatus status);

        /**
         * <p>
         * Information about how the deployment is progressing.
         * </p>
         * 
         * @param progressDetail
         *        Information about how the deployment is progressing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressDetail(ProgressDetail progressDetail);

        /**
         * <p>
         * Information about how the deployment is progressing.
         * </p>
         * This is a convenience that creates an instance of the {@link ProgressDetail.Builder} avoiding the need to
         * create one manually via {@link ProgressDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProgressDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #progressDetail(ProgressDetail)}.
         * 
         * @param progressDetail
         *        a consumer that will call methods on {@link ProgressDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressDetail(ProgressDetail)
         */
        default Builder progressDetail(Consumer<ProgressDetail.Builder> progressDetail) {
            return progressDetail(ProgressDetail.builder().applyMutation(progressDetail).build());
        }

        /**
         * <p>
         * A short description of the reason why the robot deployment failed.
         * </p>
         * 
         * @param failureReason
         *        A short description of the reason why the robot deployment failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The robot deployment failure code.
         * </p>
         * 
         * @param failureCode
         *        The robot deployment failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The robot deployment failure code.
         * </p>
         * 
         * @param failureCode
         *        The robot deployment failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(DeploymentJobErrorCode failureCode);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant deploymentStartTime;

        private Instant deploymentFinishTime;

        private String status;

        private ProgressDetail progressDetail;

        private String failureReason;

        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotDeployment model) {
            arn(model.arn);
            deploymentStartTime(model.deploymentStartTime);
            deploymentFinishTime(model.deploymentFinishTime);
            status(model.status);
            progressDetail(model.progressDetail);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getDeploymentStartTime() {
            return deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        public final Instant getDeploymentFinishTime() {
            return deploymentFinishTime;
        }

        @Override
        public final Builder deploymentFinishTime(Instant deploymentFinishTime) {
            this.deploymentFinishTime = deploymentFinishTime;
            return this;
        }

        public final void setDeploymentFinishTime(Instant deploymentFinishTime) {
            this.deploymentFinishTime = deploymentFinishTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RobotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ProgressDetail.Builder getProgressDetail() {
            return progressDetail != null ? progressDetail.toBuilder() : null;
        }

        @Override
        public final Builder progressDetail(ProgressDetail progressDetail) {
            this.progressDetail = progressDetail;
            return this;
        }

        public final void setProgressDetail(ProgressDetail.BuilderImpl progressDetail) {
            this.progressDetail = progressDetail != null ? progressDetail.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public RobotDeployment build() {
            return new RobotDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
