/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.WorldCount;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorldGenerationJobResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, CreateWorldGenerationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::arn)).setter(CreateWorldGenerationJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::statusAsString)).setter(CreateWorldGenerationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::createdAt)).setter(CreateWorldGenerationJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::failureCodeAsString)).setter(CreateWorldGenerationJobResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::clientRequestToken)).setter(CreateWorldGenerationJobResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::template)).setter(CreateWorldGenerationJobResponse.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("worldCount").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::worldCount)).setter(CreateWorldGenerationJobResponse.setter(Builder::worldCount)).constructor(WorldCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::tags)).setter(CreateWorldGenerationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> WORLD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("worldTags").getter(CreateWorldGenerationJobResponse.getter(CreateWorldGenerationJobResponse::worldTags)).setter(CreateWorldGenerationJobResponse.setter(Builder::worldTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, FAILURE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TEMPLATE_FIELD, WORLD_COUNT_FIELD, TAGS_FIELD, WORLD_TAGS_FIELD));
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final String failureCode;
    private final String clientRequestToken;
    private final String template;
    private final WorldCount worldCount;
    private final Map<String, String> tags;
    private final Map<String, String> worldTags;

    private CreateWorldGenerationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.clientRequestToken = builder.clientRequestToken;
        this.template = builder.template;
        this.worldCount = builder.worldCount;
        this.tags = builder.tags;
        this.worldTags = builder.worldTags;
    }

    public String arn() {
        return this.arn;
    }

    public WorldGenerationJobStatus status() {
        return WorldGenerationJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public WorldGenerationJobErrorCode failureCode() {
        return WorldGenerationJobErrorCode.fromValue(this.failureCode);
    }

    public String failureCodeAsString() {
        return this.failureCode;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String template() {
        return this.template;
    }

    public WorldCount worldCount() {
        return this.worldCount;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasWorldTags() {
        return this.worldTags != null && !(this.worldTags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> worldTags() {
        return this.worldTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorldTags() ? this.worldTags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldGenerationJobResponse)) {
            return false;
        }
        CreateWorldGenerationJobResponse other = (CreateWorldGenerationJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.worldCount(), other.worldCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasWorldTags() == other.hasWorldTags() && Objects.equals(this.worldTags(), other.worldTags());
    }

    public String toString() {
        return ToString.builder((String)"CreateWorldGenerationJobResponse").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("FailureCode", (Object)this.failureCodeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Template", (Object)this.template()).add("WorldCount", (Object)this.worldCount()).add("Tags", this.hasTags() ? this.tags() : null).add("WorldTags", this.hasWorldTags() ? this.worldTags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "worldCount": {
                return Optional.ofNullable(clazz.cast(this.worldCount()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "worldTags": {
                return Optional.ofNullable(clazz.cast(this.worldTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldGenerationJobResponse, T> g) {
        return obj -> g.apply((CreateWorldGenerationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private String failureCode;
        private String clientRequestToken;
        private String template;
        private WorldCount worldCount;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> worldTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldGenerationJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.failureCode(model.failureCode);
            this.clientRequestToken(model.clientRequestToken);
            this.template(model.template);
            this.worldCount(model.worldCount);
            this.tags(model.tags);
            this.worldTags(model.worldTags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldGenerationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final WorldCount.Builder getWorldCount() {
            return this.worldCount != null ? this.worldCount.toBuilder() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Map<String, String> getWorldTags() {
            if (this.worldTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.worldTags;
        }

        @Override
        public final Builder worldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
            return this;
        }

        public final void setWorldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
        }

        @Override
        public CreateWorldGenerationJobResponse build() {
            return new CreateWorldGenerationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorldGenerationJobResponse> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(WorldGenerationJobStatus var1);

        public Builder createdAt(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureCode(WorldGenerationJobErrorCode var1);

        public Builder clientRequestToken(String var1);

        public Builder template(String var1);

        public Builder worldCount(WorldCount var1);

        default public Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return this.worldCount((WorldCount)((WorldCount.Builder)WorldCount.builder().applyMutation(worldCount)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder worldTags(Map<String, String> var1);
    }
}

