/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.BatchPolicy;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequestsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.SimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSimulationJobBatchRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, StartSimulationJobBatchRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartSimulationJobBatchRequest.getter(StartSimulationJobBatchRequest::clientRequestToken)).setter(StartSimulationJobBatchRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<BatchPolicy> BATCH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchPolicy").getter(StartSimulationJobBatchRequest.getter(StartSimulationJobBatchRequest::batchPolicy)).setter(StartSimulationJobBatchRequest.setter(Builder::batchPolicy)).constructor(BatchPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPolicy").build()}).build();
    private static final SdkField<List<SimulationJobRequest>> CREATE_SIMULATION_JOB_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("createSimulationJobRequests").getter(StartSimulationJobBatchRequest.getter(StartSimulationJobBatchRequest::createSimulationJobRequests)).setter(StartSimulationJobBatchRequest.setter(Builder::createSimulationJobRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createSimulationJobRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartSimulationJobBatchRequest.getter(StartSimulationJobBatchRequest::tags)).setter(StartSimulationJobBatchRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, BATCH_POLICY_FIELD, CREATE_SIMULATION_JOB_REQUESTS_FIELD, TAGS_FIELD));
    private final String clientRequestToken;
    private final BatchPolicy batchPolicy;
    private final List<SimulationJobRequest> createSimulationJobRequests;
    private final Map<String, String> tags;

    private StartSimulationJobBatchRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.batchPolicy = builder.batchPolicy;
        this.createSimulationJobRequests = builder.createSimulationJobRequests;
        this.tags = builder.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public BatchPolicy batchPolicy() {
        return this.batchPolicy;
    }

    public boolean hasCreateSimulationJobRequests() {
        return this.createSimulationJobRequests != null && !(this.createSimulationJobRequests instanceof SdkAutoConstructList);
    }

    public List<SimulationJobRequest> createSimulationJobRequests() {
        return this.createSimulationJobRequests;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateSimulationJobRequests() ? this.createSimulationJobRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSimulationJobBatchRequest)) {
            return false;
        }
        StartSimulationJobBatchRequest other = (StartSimulationJobBatchRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.batchPolicy(), other.batchPolicy()) && this.hasCreateSimulationJobRequests() == other.hasCreateSimulationJobRequests() && Objects.equals(this.createSimulationJobRequests(), other.createSimulationJobRequests()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"StartSimulationJobBatchRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("BatchPolicy", (Object)this.batchPolicy()).add("CreateSimulationJobRequests", this.hasCreateSimulationJobRequests() ? this.createSimulationJobRequests() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "batchPolicy": {
                return Optional.ofNullable(clazz.cast(this.batchPolicy()));
            }
            case "createSimulationJobRequests": {
                return Optional.ofNullable(clazz.cast(this.createSimulationJobRequests()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSimulationJobBatchRequest, T> g) {
        return obj -> g.apply((StartSimulationJobBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private BatchPolicy batchPolicy;
        private List<SimulationJobRequest> createSimulationJobRequests = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSimulationJobBatchRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.batchPolicy(model.batchPolicy);
            this.createSimulationJobRequests(model.createSimulationJobRequests);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final BatchPolicy.Builder getBatchPolicy() {
            return this.batchPolicy != null ? this.batchPolicy.toBuilder() : null;
        }

        @Override
        public final Builder batchPolicy(BatchPolicy batchPolicy) {
            this.batchPolicy = batchPolicy;
            return this;
        }

        public final void setBatchPolicy(BatchPolicy.BuilderImpl batchPolicy) {
            this.batchPolicy = batchPolicy != null ? batchPolicy.build() : null;
        }

        public final Collection<SimulationJobRequest.Builder> getCreateSimulationJobRequests() {
            if (this.createSimulationJobRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createSimulationJobRequests != null ? (Collection)this.createSimulationJobRequests.stream().map(SimulationJobRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createSimulationJobRequests(Collection<SimulationJobRequest> createSimulationJobRequests) {
            this.createSimulationJobRequests = CreateSimulationJobRequestsCopier.copy(createSimulationJobRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createSimulationJobRequests(SimulationJobRequest ... createSimulationJobRequests) {
            this.createSimulationJobRequests(Arrays.asList(createSimulationJobRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createSimulationJobRequests(Consumer<SimulationJobRequest.Builder> ... createSimulationJobRequests) {
            this.createSimulationJobRequests(Stream.of(createSimulationJobRequests).map(c -> (SimulationJobRequest)((SimulationJobRequest.Builder)SimulationJobRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateSimulationJobRequests(Collection<SimulationJobRequest.BuilderImpl> createSimulationJobRequests) {
            this.createSimulationJobRequests = CreateSimulationJobRequestsCopier.copyFromBuilder(createSimulationJobRequests);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSimulationJobBatchRequest build() {
            return new StartSimulationJobBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSimulationJobBatchRequest> {
        public Builder clientRequestToken(String var1);

        public Builder batchPolicy(BatchPolicy var1);

        default public Builder batchPolicy(Consumer<BatchPolicy.Builder> batchPolicy) {
            return this.batchPolicy((BatchPolicy)((BatchPolicy.Builder)BatchPolicy.builder().applyMutation(batchPolicy)).build());
        }

        public Builder createSimulationJobRequests(Collection<SimulationJobRequest> var1);

        public Builder createSimulationJobRequests(SimulationJobRequest ... var1);

        public Builder createSimulationJobRequests(Consumer<SimulationJobRequest.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

