/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for port forwarding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortForwardingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PortForwardingConfig.Builder, PortForwardingConfig> {
    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField
            .<List<PortMapping>> builder(MarshallingType.LIST)
            .getter(getter(PortForwardingConfig::portMappings))
            .setter(setter(Builder::portMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PortMapping> portMappings;

    private PortForwardingConfig(BuilderImpl builder) {
        this.portMappings = builder.portMappings;
    }

    /**
     * Returns true if the PortMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPortMappings() {
        return portMappings != null && !(portMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port mappings for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The port mappings for the configuration.
     */
    public List<PortMapping> portMappings() {
        return portMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portMappings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortForwardingConfig)) {
            return false;
        }
        PortForwardingConfig other = (PortForwardingConfig) obj;
        return Objects.equals(portMappings(), other.portMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PortForwardingConfig").add("PortMappings", portMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portMappings":
            return Optional.ofNullable(clazz.cast(portMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortForwardingConfig, T> g) {
        return obj -> g.apply((PortForwardingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortForwardingConfig> {
        /**
         * <p>
         * The port mappings for the configuration.
         * </p>
         * 
         * @param portMappings
         *        The port mappings for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(Collection<PortMapping> portMappings);

        /**
         * <p>
         * The port mappings for the configuration.
         * </p>
         * 
         * @param portMappings
         *        The port mappings for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(PortMapping... portMappings);

        /**
         * <p>
         * The port mappings for the configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortMapping>.Builder} avoiding the need to
         * create one manually via {@link List<PortMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortMapping>.Builder#build()} is called immediately and its
         * result is passed to {@link #portMappings(List<PortMapping>)}.
         * 
         * @param portMappings
         *        a consumer that will call methods on {@link List<PortMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMappings(List<PortMapping>)
         */
        Builder portMappings(Consumer<PortMapping.Builder>... portMappings);
    }

    static final class BuilderImpl implements Builder {
        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortForwardingConfig model) {
            portMappings(model.portMappings);
        }

        public final Collection<PortMapping.Builder> getPortMappings() {
            return portMappings != null ? portMappings.stream().map(PortMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingListCopier.copy(portMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(PortMapping... portMappings) {
            portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder>... portMappings) {
            portMappings(Stream.of(portMappings).map(c -> PortMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingListCopier.copyFromBuilder(portMappings);
        }

        @Override
        public PortForwardingConfig build() {
            return new PortForwardingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
