/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about S3 keys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3KeyOutput implements SdkPojo, Serializable, ToCopyableBuilder<S3KeyOutput.Builder, S3KeyOutput> {
    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3KeyOutput::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()).build();

    private static final SdkField<String> ETAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3KeyOutput::etag)).setter(setter(Builder::etag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_KEY_FIELD, ETAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Key;

    private final String etag;

    private S3KeyOutput(BuilderImpl builder) {
        this.s3Key = builder.s3Key;
        this.etag = builder.etag;
    }

    /**
     * <p>
     * The S3 key.
     * </p>
     * 
     * @return The S3 key.
     */
    public String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * The etag for the object.
     * </p>
     * 
     * @return The etag for the object.
     */
    public String etag() {
        return etag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(etag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyOutput)) {
            return false;
        }
        S3KeyOutput other = (S3KeyOutput) obj;
        return Objects.equals(s3Key(), other.s3Key()) && Objects.equals(etag(), other.etag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3KeyOutput").add("S3Key", s3Key()).add("Etag", etag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "etag":
            return Optional.ofNullable(clazz.cast(etag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3KeyOutput, T> g) {
        return obj -> g.apply((S3KeyOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3KeyOutput> {
        /**
         * <p>
         * The S3 key.
         * </p>
         * 
         * @param s3Key
         *        The S3 key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * The etag for the object.
         * </p>
         * 
         * @param etag
         *        The etag for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etag(String etag);
    }

    static final class BuilderImpl implements Builder {
        private String s3Key;

        private String etag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KeyOutput model) {
            s3Key(model.s3Key);
            etag(model.etag);
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getEtag() {
            return etag;
        }

        @Override
        public final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public final void setEtag(String etag) {
            this.etag = etag;
        }

        @Override
        public S3KeyOutput build() {
            return new S3KeyOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
