/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a robot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Robot implements SdkPojo, Serializable, ToCopyableBuilder<Robot.Builder, Robot> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> GREEN_GRASS_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::greenGrassGroupId)).setter(setter(Builder::greenGrassGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greenGrassGroupId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Robot::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Robot::lastDeploymentJob)).setter(setter(Builder::lastDeploymentJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()).build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Robot::lastDeploymentTime)).setter(setter(Builder::lastDeploymentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            FLEET_ARN_FIELD, STATUS_FIELD, GREEN_GRASS_GROUP_ID_FIELD, CREATED_AT_FIELD, ARCHITECTURE_FIELD,
            LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String fleetArn;

    private final String status;

    private final String greenGrassGroupId;

    private final Instant createdAt;

    private final String architecture;

    private final String lastDeploymentJob;

    private final Instant lastDeploymentTime;

    private Robot(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.fleetArn = builder.fleetArn;
        this.status = builder.status;
        this.greenGrassGroupId = builder.greenGrassGroupId;
        this.createdAt = builder.createdAt;
        this.architecture = builder.architecture;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the robot.
     * </p>
     * 
     * @return The name of the robot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The status of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the robot.
     * @see RobotStatus
     */
    public RobotStatus status() {
        return RobotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the robot.
     * @see RobotStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Greengrass group associated with the robot.
     * </p>
     * 
     * @return The Greengrass group associated with the robot.
     */
    public String greenGrassGroupId() {
        return greenGrassGroupId;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the robot was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the robot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The architecture of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the robot.
     * @see Architecture
     */
    public Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the robot.
     * @see Architecture
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the last deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the last deployment job.
     */
    public String lastDeploymentJob() {
        return lastDeploymentJob;
    }

    /**
     * <p>
     * The time of the last deployment.
     * </p>
     * 
     * @return The time of the last deployment.
     */
    public Instant lastDeploymentTime() {
        return lastDeploymentTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(greenGrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Robot)) {
            return false;
        }
        Robot other = (Robot) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(greenGrassGroupId(), other.greenGrassGroupId())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(lastDeploymentJob(), other.lastDeploymentJob())
                && Objects.equals(lastDeploymentTime(), other.lastDeploymentTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Robot").add("Arn", arn()).add("Name", name()).add("FleetArn", fleetArn())
                .add("Status", statusAsString()).add("GreenGrassGroupId", greenGrassGroupId()).add("CreatedAt", createdAt())
                .add("Architecture", architectureAsString()).add("LastDeploymentJob", lastDeploymentJob())
                .add("LastDeploymentTime", lastDeploymentTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "greenGrassGroupId":
            return Optional.ofNullable(clazz.cast(greenGrassGroupId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "lastDeploymentJob":
            return Optional.ofNullable(clazz.cast(lastDeploymentJob()));
        case "lastDeploymentTime":
            return Optional.ofNullable(clazz.cast(lastDeploymentTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Robot, T> g) {
        return obj -> g.apply((Robot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Robot> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the robot.
         * </p>
         * 
         * @param name
         *        The name of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The status of the robot.
         * </p>
         * 
         * @param status
         *        The status of the robot.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the robot.
         * </p>
         * 
         * @param status
         *        The status of the robot.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(RobotStatus status);

        /**
         * <p>
         * The Greengrass group associated with the robot.
         * </p>
         * 
         * @param greenGrassGroupId
         *        The Greengrass group associated with the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greenGrassGroupId(String greenGrassGroupId);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the robot was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the robot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The architecture of the robot.
         * </p>
         * 
         * @param architecture
         *        The architecture of the robot.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the robot.
         * </p>
         * 
         * @param architecture
         *        The architecture of the robot.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the last deployment job.
         * </p>
         * 
         * @param lastDeploymentJob
         *        The Amazon Resource Name (ARN) of the last deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentJob(String lastDeploymentJob);

        /**
         * <p>
         * The time of the last deployment.
         * </p>
         * 
         * @param lastDeploymentTime
         *        The time of the last deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentTime(Instant lastDeploymentTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String fleetArn;

        private String status;

        private String greenGrassGroupId;

        private Instant createdAt;

        private String architecture;

        private String lastDeploymentJob;

        private Instant lastDeploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Robot model) {
            arn(model.arn);
            name(model.name);
            fleetArn(model.fleetArn);
            status(model.status);
            greenGrassGroupId(model.greenGrassGroupId);
            createdAt(model.createdAt);
            architecture(model.architecture);
            lastDeploymentJob(model.lastDeploymentJob);
            lastDeploymentTime(model.lastDeploymentTime);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RobotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGreenGrassGroupId() {
            return greenGrassGroupId;
        }

        @Override
        public final Builder greenGrassGroupId(String greenGrassGroupId) {
            this.greenGrassGroupId = greenGrassGroupId;
            return this;
        }

        public final void setGreenGrassGroupId(String greenGrassGroupId) {
            this.greenGrassGroupId = greenGrassGroupId;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getArchitectureAsString() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getLastDeploymentJob() {
            return lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        public final Instant getLastDeploymentTime() {
            return lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        @Override
        public Robot build() {
            return new Robot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
