/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite;
import software.amazon.awssdk.services.robomaker.model.Source;
import software.amazon.awssdk.services.robomaker.model.SourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRobotApplicationResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, CreateRobotApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::arn)).setter(CreateRobotApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::name)).setter(CreateRobotApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::version)).setter(CreateRobotApplicationResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::sources)).setter(CreateRobotApplicationResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::robotSoftwareSuite)).setter(CreateRobotApplicationResponse.setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::lastUpdatedAt)).setter(CreateRobotApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRobotApplicationResponse.getter(CreateRobotApplicationResponse::revisionId)).setter(CreateRobotApplicationResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, SOURCES_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, LAST_UPDATED_AT_FIELD, REVISION_ID_FIELD));
    private final String arn;
    private final String name;
    private final String version;
    private final List<Source> sources;
    private final RobotSoftwareSuite robotSoftwareSuite;
    private final Instant lastUpdatedAt;
    private final String revisionId;

    private CreateRobotApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.sources = builder.sources;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.revisionId = builder.revisionId;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public List<Source> sources() {
        return this.sources;
    }

    public RobotSoftwareSuite robotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationResponse)) {
            return false;
        }
        CreateRobotApplicationResponse other = (CreateRobotApplicationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.robotSoftwareSuite(), other.robotSoftwareSuite()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateRobotApplicationResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Sources", this.sources()).add("RobotSoftwareSuite", (Object)this.robotSoftwareSuite()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "robotSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.robotSoftwareSuite()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRobotApplicationResponse, T> g) {
        return obj -> g.apply((CreateRobotApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();
        private RobotSoftwareSuite robotSoftwareSuite;
        private Instant lastUpdatedAt;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRobotApplicationResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.sources(model.sources);
            this.robotSoftwareSuite(model.robotSoftwareSuite);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.revisionId(model.revisionId);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<Source.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(Source::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (Source)((Source.Builder)Source.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = SourcesCopier.copyFromBuilder(sources);
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return this.robotSoftwareSuite != null ? this.robotSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public CreateRobotApplicationResponse build() {
            return new CreateRobotApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRobotApplicationResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder sources(Collection<Source> var1);

        public Builder sources(Source ... var1);

        public Builder sources(Consumer<Source.Builder> ... var1);

        public Builder robotSoftwareSuite(RobotSoftwareSuite var1);

        default public Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return this.robotSoftwareSuite((RobotSoftwareSuite)((RobotSoftwareSuite.Builder)RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite)).build());
        }

        public Builder lastUpdatedAt(Instant var1);

        public Builder revisionId(String var1);
    }
}

