/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.AccountSettings;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountSettingsResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, UpdateAccountSettingsResponse> {
    private static final SdkField<AccountSettings> ACCOUNT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountSettings").getter(UpdateAccountSettingsResponse.getter(UpdateAccountSettingsResponse::accountSettings)).setter(UpdateAccountSettingsResponse.setter(Builder::accountSettings)).constructor(AccountSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccountSettingsResponse.memberNameToFieldInitializer();
    private final AccountSettings accountSettings;

    private UpdateAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettings = builder.accountSettings;
    }

    public final AccountSettings accountSettings() {
        return this.accountSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsResponse)) {
            return false;
        }
        UpdateAccountSettingsResponse other = (UpdateAccountSettingsResponse)((Object)obj);
        return Objects.equals(this.accountSettings(), other.accountSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccountSettingsResponse").add("AccountSettings", (Object)this.accountSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountSettings": {
                return Optional.ofNullable(clazz.cast(this.accountSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AccountSettings>> map = new HashMap<String, SdkField<AccountSettings>>();
        map.put("AccountSettings", ACCOUNT_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsResponse, T> g) {
        return obj -> g.apply((UpdateAccountSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private AccountSettings accountSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsResponse model) {
            super(model);
            this.accountSettings(model.accountSettings);
        }

        public final AccountSettings.Builder getAccountSettings() {
            return this.accountSettings != null ? this.accountSettings.toBuilder() : null;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        @Override
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        @Override
        public UpdateAccountSettingsResponse build() {
            return new UpdateAccountSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountSettingsResponse> {
        public Builder accountSettings(AccountSettings var1);

        default public Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return this.accountSettings((AccountSettings)((AccountSettings.Builder)AccountSettings.builder().applyMutation(accountSettings)).build());
        }
    }
}

