/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.resourcegroups.model.TagRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TagRequestModelMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final TagRequestModelMarshaller INSTANCE = new TagRequestModelMarshaller();

    private TagRequestModelMarshaller() {
    }

    public static TagRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TagRequest tagRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)tagRequest), (String)"tagRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tagRequest.arn(), ARN_BINDING);
            protocolMarshaller.marshall(tagRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

