/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails;

public class ListStreamingAccessForServicesPublisher
implements SdkPublisher<ListStreamingAccessForServicesResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListStreamingAccessForServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamingAccessForServicesPublisher(ResourceExplorer2AsyncClient client, ListStreamingAccessForServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamingAccessForServicesPublisher(ResourceExplorer2AsyncClient client, ListStreamingAccessForServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamingAccessForServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamingAccessForServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamingAccessDetails> streamingAccessForServices() {
        Function<ListStreamingAccessForServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingAccessForServices() != null) {
                return response.streamingAccessForServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamingAccessForServicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamingAccessForServicesResponseFetcher
    implements AsyncPageFetcher<ListStreamingAccessForServicesResponse> {
        private ListStreamingAccessForServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingAccessForServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamingAccessForServicesResponse> nextPage(ListStreamingAccessForServicesResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingAccessForServicesPublisher.this.client.listStreamingAccessForServices(ListStreamingAccessForServicesPublisher.this.firstRequest);
            }
            return ListStreamingAccessForServicesPublisher.this.client.listStreamingAccessForServices((ListStreamingAccessForServicesRequest)((Object)ListStreamingAccessForServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

