/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration and properties of a Resource Explorer service view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceView implements SdkPojo, Serializable, ToCopyableBuilder<ServiceView.Builder, ServiceView> {
    private static final SdkField<String> SERVICE_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceViewArn").getter(getter(ServiceView::serviceViewArn)).setter(setter(Builder::serviceViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceViewArn").build()).build();

    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.<SearchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(ServiceView::filters)).setter(setter(Builder::filters))
            .constructor(SearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField
            .<List<IncludedProperty>> builder(MarshallingType.LIST)
            .memberName("IncludedProperties")
            .getter(getter(ServiceView::includedProperties))
            .setter(setter(Builder::includedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncludedProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncludedProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STREAMING_ACCESS_FOR_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamingAccessForService").getter(getter(ServiceView::streamingAccessForService))
            .setter(setter(Builder::streamingAccessForService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingAccessForService").build())
            .build();

    private static final SdkField<String> SCOPE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScopeType").getter(getter(ServiceView::scopeType)).setter(setter(Builder::scopeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_VIEW_ARN_FIELD,
            FILTERS_FIELD, INCLUDED_PROPERTIES_FIELD, STREAMING_ACCESS_FOR_SERVICE_FIELD, SCOPE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceViewArn;

    private final SearchFilter filters;

    private final List<IncludedProperty> includedProperties;

    private final String streamingAccessForService;

    private final String scopeType;

    private ServiceView(BuilderImpl builder) {
        this.serviceViewArn = builder.serviceViewArn;
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.streamingAccessForService = builder.streamingAccessForService;
        this.scopeType = builder.scopeType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service view.
     */
    public final String serviceViewArn() {
        return serviceViewArn;
    }

    /**
     * Returns the value of the Filters property for this object.
     * 
     * @return The value of the Filters property for this object.
     */
    public final SearchFilter filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedProperties() {
        return includedProperties != null && !(includedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional resource properties that are included in this view for search and filtering purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedProperties} method.
     * </p>
     * 
     * @return A list of additional resource properties that are included in this view for search and filtering
     *         purposes.
     */
    public final List<IncludedProperty> includedProperties() {
        return includedProperties;
    }

    /**
     * <p>
     * The Amazon Web Services service that has streaming access to this view's data.
     * </p>
     * 
     * @return The Amazon Web Services service that has streaming access to this view's data.
     */
    public final String streamingAccessForService() {
        return streamingAccessForService;
    }

    /**
     * <p>
     * The scope type of the service view, which determines what resources are included.
     * </p>
     * 
     * @return The scope type of the service view, which determines what resources are included.
     */
    public final String scopeType() {
        return scopeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedProperties() ? includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamingAccessForService());
        hashCode = 31 * hashCode + Objects.hashCode(scopeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceView)) {
            return false;
        }
        ServiceView other = (ServiceView) obj;
        return Objects.equals(serviceViewArn(), other.serviceViewArn()) && Objects.equals(filters(), other.filters())
                && hasIncludedProperties() == other.hasIncludedProperties()
                && Objects.equals(includedProperties(), other.includedProperties())
                && Objects.equals(streamingAccessForService(), other.streamingAccessForService())
                && Objects.equals(scopeType(), other.scopeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceView").add("ServiceViewArn", serviceViewArn())
                .add("Filters", filters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludedProperties", hasIncludedProperties() ? includedProperties() : null)
                .add("StreamingAccessForService", streamingAccessForService()).add("ScopeType", scopeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceViewArn":
            return Optional.ofNullable(clazz.cast(serviceViewArn()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "IncludedProperties":
            return Optional.ofNullable(clazz.cast(includedProperties()));
        case "StreamingAccessForService":
            return Optional.ofNullable(clazz.cast(streamingAccessForService()));
        case "ScopeType":
            return Optional.ofNullable(clazz.cast(scopeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceViewArn", SERVICE_VIEW_ARN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("IncludedProperties", INCLUDED_PROPERTIES_FIELD);
        map.put("StreamingAccessForService", STREAMING_ACCESS_FOR_SERVICE_FIELD);
        map.put("ScopeType", SCOPE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceView, T> g) {
        return obj -> g.apply((ServiceView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceView> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service view.
         * </p>
         * 
         * @param serviceViewArn
         *        The Amazon Resource Name (ARN) of the service view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceViewArn(String serviceViewArn);

        /**
         * Sets the value of the Filters property for this object.
         *
         * @param filters
         *        The new value for the Filters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilter filters);

        /**
         * Sets the value of the Filters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SearchFilter.Builder} avoiding the need
         * to create one manually via {@link SearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(SearchFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SearchFilter)
         */
        default Builder filters(Consumer<SearchFilter.Builder> filters) {
            return filters(SearchFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * A list of additional resource properties that are included in this view for search and filtering purposes.
         * </p>
         * 
         * @param includedProperties
         *        A list of additional resource properties that are included in this view for search and filtering
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(Collection<IncludedProperty> includedProperties);

        /**
         * <p>
         * A list of additional resource properties that are included in this view for search and filtering purposes.
         * </p>
         * 
         * @param includedProperties
         *        A list of additional resource properties that are included in this view for search and filtering
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(IncludedProperty... includedProperties);

        /**
         * <p>
         * A list of additional resource properties that are included in this view for search and filtering purposes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #includedProperties(List<IncludedProperty>)}.
         * 
         * @param includedProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedProperties(java.util.Collection<IncludedProperty>)
         */
        Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties);

        /**
         * <p>
         * The Amazon Web Services service that has streaming access to this view's data.
         * </p>
         * 
         * @param streamingAccessForService
         *        The Amazon Web Services service that has streaming access to this view's data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingAccessForService(String streamingAccessForService);

        /**
         * <p>
         * The scope type of the service view, which determines what resources are included.
         * </p>
         * 
         * @param scopeType
         *        The scope type of the service view, which determines what resources are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeType(String scopeType);
    }

    static final class BuilderImpl implements Builder {
        private String serviceViewArn;

        private SearchFilter filters;

        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();

        private String streamingAccessForService;

        private String scopeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceView model) {
            serviceViewArn(model.serviceViewArn);
            filters(model.filters);
            includedProperties(model.includedProperties);
            streamingAccessForService(model.streamingAccessForService);
            scopeType(model.scopeType);
        }

        public final String getServiceViewArn() {
            return serviceViewArn;
        }

        public final void setServiceViewArn(String serviceViewArn) {
            this.serviceViewArn = serviceViewArn;
        }

        @Override
        public final Builder serviceViewArn(String serviceViewArn) {
            this.serviceViewArn = serviceViewArn;
            return this;
        }

        public final SearchFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty... includedProperties) {
            includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties) {
            includedProperties(Stream.of(includedProperties).map(c -> IncludedProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStreamingAccessForService() {
            return streamingAccessForService;
        }

        public final void setStreamingAccessForService(String streamingAccessForService) {
            this.streamingAccessForService = streamingAccessForService;
        }

        @Override
        public final Builder streamingAccessForService(String streamingAccessForService) {
            this.streamingAccessForService = streamingAccessForService;
            return this;
        }

        public final String getScopeType() {
            return scopeType;
        }

        public final void setScopeType(String scopeType) {
            this.scopeType = scopeType;
        }

        @Override
        public final Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            return this;
        }

        @Override
        public ServiceView build() {
            return new ServiceView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
