/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a property of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceProperty.Builder, ResourceProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> LAST_REPORTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastReportedAt")
            .getter(getter(ResourceProperty::lastReportedAt))
            .setter(setter(Builder::lastReportedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReportedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Document> DATA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("Data")
            .getter(getter(ResourceProperty::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            LAST_REPORTED_AT_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant lastReportedAt;

    private final Document data;

    private ResourceProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.lastReportedAt = builder.lastReportedAt;
        this.data = builder.data;
    }

    /**
     * <p>
     * The name of this property of the resource.
     * </p>
     * 
     * @return The name of this property of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time that the information about this resource property was last updated.
     * </p>
     * 
     * @return The date and time that the information about this resource property was last updated.
     */
    public final Instant lastReportedAt() {
        return lastReportedAt;
    }

    /**
     * <p>
     * Details about this property. The content of this field is a JSON object that varies based on the resource type.
     * </p>
     * 
     * @return Details about this property. The content of this field is a JSON object that varies based on the resource
     *         type.
     */
    public final Document data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lastReportedAt());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceProperty)) {
            return false;
        }
        ResourceProperty other = (ResourceProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lastReportedAt(), other.lastReportedAt())
                && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceProperty").add("Name", name()).add("LastReportedAt", lastReportedAt())
                .add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LastReportedAt":
            return Optional.ofNullable(clazz.cast(lastReportedAt()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("LastReportedAt", LAST_REPORTED_AT_FIELD);
        map.put("Data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceProperty, T> g) {
        return obj -> g.apply((ResourceProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceProperty> {
        /**
         * <p>
         * The name of this property of the resource.
         * </p>
         * 
         * @param name
         *        The name of this property of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time that the information about this resource property was last updated.
         * </p>
         * 
         * @param lastReportedAt
         *        The date and time that the information about this resource property was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReportedAt(Instant lastReportedAt);

        /**
         * <p>
         * Details about this property. The content of this field is a JSON object that varies based on the resource
         * type.
         * </p>
         * 
         * @param data
         *        Details about this property. The content of this field is a JSON object that varies based on the
         *        resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Document data);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant lastReportedAt;

        private Document data;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceProperty model) {
            name(model.name);
            lastReportedAt(model.lastReportedAt);
            data(model.data);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getLastReportedAt() {
            return lastReportedAt;
        }

        public final void setLastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
        }

        @Override
        public final Builder lastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
            return this;
        }

        public final Document getData() {
            return data;
        }

        public final void setData(Document data) {
            this.data = data;
        }

        @Override
        public final Builder data(Document data) {
            this.data = data;
            return this;
        }

        @Override
        public ResourceProperty build() {
            return new ResourceProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
