/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamingAccessForServicesResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<ListStreamingAccessForServicesResponse.Builder, ListStreamingAccessForServicesResponse> {
    private static final SdkField<List<StreamingAccessDetails>> STREAMING_ACCESS_FOR_SERVICES_FIELD = SdkField
            .<List<StreamingAccessDetails>> builder(MarshallingType.LIST)
            .memberName("StreamingAccessForServices")
            .getter(getter(ListStreamingAccessForServicesResponse::streamingAccessForServices))
            .setter(setter(Builder::streamingAccessForServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingAccessForServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamingAccessDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamingAccessDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamingAccessForServicesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STREAMING_ACCESS_FOR_SERVICES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StreamingAccessDetails> streamingAccessForServices;

    private final String nextToken;

    private ListStreamingAccessForServicesResponse(BuilderImpl builder) {
        super(builder);
        this.streamingAccessForServices = builder.streamingAccessForServices;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StreamingAccessForServices property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStreamingAccessForServices() {
        return streamingAccessForServices != null && !(streamingAccessForServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services services that have streaming access to your Resource Explorer data, including
     * details about when the access was granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreamingAccessForServices} method.
     * </p>
     * 
     * @return A list of Amazon Web Services services that have streaming access to your Resource Explorer data,
     *         including details about when the access was granted.
     */
    public final List<StreamingAccessDetails> streamingAccessForServices() {
        return streamingAccessForServices;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>. The pagination tokens expire after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamingAccessForServices() ? streamingAccessForServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingAccessForServicesResponse)) {
            return false;
        }
        ListStreamingAccessForServicesResponse other = (ListStreamingAccessForServicesResponse) obj;
        return hasStreamingAccessForServices() == other.hasStreamingAccessForServices()
                && Objects.equals(streamingAccessForServices(), other.streamingAccessForServices())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamingAccessForServicesResponse")
                .add("StreamingAccessForServices", hasStreamingAccessForServices() ? streamingAccessForServices() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingAccessForServices":
            return Optional.ofNullable(clazz.cast(streamingAccessForServices()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamingAccessForServices", STREAMING_ACCESS_FOR_SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingAccessForServicesResponse, T> g) {
        return obj -> g.apply((ListStreamingAccessForServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStreamingAccessForServicesResponse> {
        /**
         * <p>
         * A list of Amazon Web Services services that have streaming access to your Resource Explorer data, including
         * details about when the access was granted.
         * </p>
         * 
         * @param streamingAccessForServices
         *        A list of Amazon Web Services services that have streaming access to your Resource Explorer data,
         *        including details about when the access was granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingAccessForServices(Collection<StreamingAccessDetails> streamingAccessForServices);

        /**
         * <p>
         * A list of Amazon Web Services services that have streaming access to your Resource Explorer data, including
         * details about when the access was granted.
         * </p>
         * 
         * @param streamingAccessForServices
         *        A list of Amazon Web Services services that have streaming access to your Resource Explorer data,
         *        including details about when the access was granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingAccessForServices(StreamingAccessDetails... streamingAccessForServices);

        /**
         * <p>
         * A list of Amazon Web Services services that have streaming access to your Resource Explorer data, including
         * details about when the access was granted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #streamingAccessForServices(List<StreamingAccessDetails>)}.
         * 
         * @param streamingAccessForServices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingAccessForServices(java.util.Collection<StreamingAccessDetails>)
         */
        Builder streamingAccessForServices(Consumer<StreamingAccessDetails.Builder>... streamingAccessForServices);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>. The pagination tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>. The pagination tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private List<StreamingAccessDetails> streamingAccessForServices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingAccessForServicesResponse model) {
            super(model);
            streamingAccessForServices(model.streamingAccessForServices);
            nextToken(model.nextToken);
        }

        public final List<StreamingAccessDetails.Builder> getStreamingAccessForServices() {
            List<StreamingAccessDetails.Builder> result = StreamingAccessDetailsListCopier
                    .copyToBuilder(this.streamingAccessForServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingAccessForServices(Collection<StreamingAccessDetails.BuilderImpl> streamingAccessForServices) {
            this.streamingAccessForServices = StreamingAccessDetailsListCopier.copyFromBuilder(streamingAccessForServices);
        }

        @Override
        public final Builder streamingAccessForServices(Collection<StreamingAccessDetails> streamingAccessForServices) {
            this.streamingAccessForServices = StreamingAccessDetailsListCopier.copy(streamingAccessForServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingAccessForServices(StreamingAccessDetails... streamingAccessForServices) {
            streamingAccessForServices(Arrays.asList(streamingAccessForServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingAccessForServices(Consumer<StreamingAccessDetails.Builder>... streamingAccessForServices) {
            streamingAccessForServices(Stream.of(streamingAccessForServices)
                    .map(c -> StreamingAccessDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamingAccessForServicesResponse build() {
            return new ListStreamingAccessForServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
