/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceExplorerSetupRequest extends ResourceExplorer2Request implements
        ToCopyableBuilder<CreateResourceExplorerSetupRequest.Builder, CreateResourceExplorerSetupRequest> {
    private static final SdkField<List<String>> REGION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionList")
            .getter(getter(CreateResourceExplorerSetupRequest::regionList))
            .setter(setter(Builder::regionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGGREGATOR_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AggregatorRegions")
            .getter(getter(CreateResourceExplorerSetupRequest::aggregatorRegions))
            .setter(setter(Builder::aggregatorRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewName").getter(getter(CreateResourceExplorerSetupRequest::viewName))
            .setter(setter(Builder::viewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_LIST_FIELD,
            AGGREGATOR_REGIONS_FIELD, VIEW_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> regionList;

    private final List<String> aggregatorRegions;

    private final String viewName;

    private CreateResourceExplorerSetupRequest(BuilderImpl builder) {
        super(builder);
        this.regionList = builder.regionList;
        this.aggregatorRegions = builder.aggregatorRegions;
        this.viewName = builder.viewName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegionList() {
        return regionList != null && !(regionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the list will
     * have a user-owned index created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionList} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the
     *         list will have a user-owned index created.
     */
    public final List<String> regionList() {
        return regionList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatorRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregatorRegions() {
        return aggregatorRegions != null && !(aggregatorRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator Regions receive
     * replicated index information from all other Regions where there is a user-owned index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatorRegions} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator Regions
     *         receive replicated index information from all other Regions where there is a user-owned index.
     */
    public final List<String> aggregatorRegions() {
        return aggregatorRegions;
    }

    /**
     * <p>
     * The name for the view to be created as part of the Resource Explorer setup. The view name must be unique within
     * the Amazon Web Services account and Region.
     * </p>
     * 
     * @return The name for the view to be created as part of the Resource Explorer setup. The view name must be unique
     *         within the Amazon Web Services account and Region.
     */
    public final String viewName() {
        return viewName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionList() ? regionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatorRegions() ? aggregatorRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(viewName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceExplorerSetupRequest)) {
            return false;
        }
        CreateResourceExplorerSetupRequest other = (CreateResourceExplorerSetupRequest) obj;
        return hasRegionList() == other.hasRegionList() && Objects.equals(regionList(), other.regionList())
                && hasAggregatorRegions() == other.hasAggregatorRegions()
                && Objects.equals(aggregatorRegions(), other.aggregatorRegions()) && Objects.equals(viewName(), other.viewName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceExplorerSetupRequest").add("RegionList", hasRegionList() ? regionList() : null)
                .add("AggregatorRegions", hasAggregatorRegions() ? aggregatorRegions() : null).add("ViewName", viewName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionList":
            return Optional.ofNullable(clazz.cast(regionList()));
        case "AggregatorRegions":
            return Optional.ofNullable(clazz.cast(aggregatorRegions()));
        case "ViewName":
            return Optional.ofNullable(clazz.cast(viewName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegionList", REGION_LIST_FIELD);
        map.put("AggregatorRegions", AGGREGATOR_REGIONS_FIELD);
        map.put("ViewName", VIEW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceExplorerSetupRequest, T> g) {
        return obj -> g.apply((CreateResourceExplorerSetupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceExplorerSetupRequest> {
        /**
         * <p>
         * A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the list
         * will have a user-owned index created.
         * </p>
         * 
         * @param regionList
         *        A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the
         *        list will have a user-owned index created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionList(Collection<String> regionList);

        /**
         * <p>
         * A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the list
         * will have a user-owned index created.
         * </p>
         * 
         * @param regionList
         *        A list of Amazon Web Services Regions where Resource Explorer should be configured. Each Region in the
         *        list will have a user-owned index created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionList(String... regionList);

        /**
         * <p>
         * A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator Regions
         * receive replicated index information from all other Regions where there is a user-owned index.
         * </p>
         * 
         * @param aggregatorRegions
         *        A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator
         *        Regions receive replicated index information from all other Regions where there is a user-owned index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorRegions(Collection<String> aggregatorRegions);

        /**
         * <p>
         * A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator Regions
         * receive replicated index information from all other Regions where there is a user-owned index.
         * </p>
         * 
         * @param aggregatorRegions
         *        A list of Amazon Web Services Regions that should be configured as aggregator Regions. Aggregator
         *        Regions receive replicated index information from all other Regions where there is a user-owned index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorRegions(String... aggregatorRegions);

        /**
         * <p>
         * The name for the view to be created as part of the Resource Explorer setup. The view name must be unique
         * within the Amazon Web Services account and Region.
         * </p>
         * 
         * @param viewName
         *        The name for the view to be created as part of the Resource Explorer setup. The view name must be
         *        unique within the Amazon Web Services account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewName(String viewName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceExplorer2Request.BuilderImpl implements Builder {
        private List<String> regionList = DefaultSdkAutoConstructList.getInstance();

        private List<String> aggregatorRegions = DefaultSdkAutoConstructList.getInstance();

        private String viewName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceExplorerSetupRequest model) {
            super(model);
            regionList(model.regionList);
            aggregatorRegions(model.aggregatorRegions);
            viewName(model.viewName);
        }

        public final Collection<String> getRegionList() {
            if (regionList instanceof SdkAutoConstructList) {
                return null;
            }
            return regionList;
        }

        public final void setRegionList(Collection<String> regionList) {
            this.regionList = CreateResourceExplorerSetupInputRegionListListCopier.copy(regionList);
        }

        @Override
        public final Builder regionList(Collection<String> regionList) {
            this.regionList = CreateResourceExplorerSetupInputRegionListListCopier.copy(regionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionList(String... regionList) {
            regionList(Arrays.asList(regionList));
            return this;
        }

        public final Collection<String> getAggregatorRegions() {
            if (aggregatorRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregatorRegions;
        }

        public final void setAggregatorRegions(Collection<String> aggregatorRegions) {
            this.aggregatorRegions = CreateResourceExplorerSetupInputAggregatorRegionsListCopier.copy(aggregatorRegions);
        }

        @Override
        public final Builder aggregatorRegions(Collection<String> aggregatorRegions) {
            this.aggregatorRegions = CreateResourceExplorerSetupInputAggregatorRegionsListCopier.copy(aggregatorRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorRegions(String... aggregatorRegions) {
            aggregatorRegions(Arrays.asList(aggregatorRegions));
            return this;
        }

        public final String getViewName() {
            return viewName;
        }

        public final void setViewName(String viewName) {
            this.viewName = viewName;
        }

        @Override
        public final Builder viewName(String viewName) {
            this.viewName = viewName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceExplorerSetupRequest build() {
            return new CreateResourceExplorerSetupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
