/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedPropertyListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedView
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedView> {
    private static final SdkField<String> MANAGED_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedViewArn").getter(ManagedView.getter(ManagedView::managedViewArn)).setter(ManagedView.setter(Builder::managedViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedViewArn").build()}).build();
    private static final SdkField<String> MANAGED_VIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedViewName").getter(ManagedView.getter(ManagedView::managedViewName)).setter(ManagedView.setter(Builder::managedViewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedViewName").build()}).build();
    private static final SdkField<String> TRUSTED_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedService").getter(ManagedView.getter(ManagedView::trustedService)).setter(ManagedView.setter(Builder::trustedService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedService").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(ManagedView.getter(ManagedView::lastUpdatedAt)).setter(ManagedView.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ManagedView.getter(ManagedView::owner)).setter(ManagedView.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ManagedView.getter(ManagedView::scope)).setter(ManagedView.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedProperties").getter(ManagedView.getter(ManagedView::includedProperties)).setter(ManagedView.setter(Builder::includedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncludedProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(ManagedView.getter(ManagedView::filters)).setter(ManagedView.setter(Builder::filters)).constructor(SearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePolicy").getter(ManagedView.getter(ManagedView::resourcePolicy)).setter(ManagedView.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(ManagedView.getter(ManagedView::version)).setter(ManagedView.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_VIEW_ARN_FIELD, MANAGED_VIEW_NAME_FIELD, TRUSTED_SERVICE_FIELD, LAST_UPDATED_AT_FIELD, OWNER_FIELD, SCOPE_FIELD, INCLUDED_PROPERTIES_FIELD, FILTERS_FIELD, RESOURCE_POLICY_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedView.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String managedViewArn;
    private final String managedViewName;
    private final String trustedService;
    private final Instant lastUpdatedAt;
    private final String owner;
    private final String scope;
    private final List<IncludedProperty> includedProperties;
    private final SearchFilter filters;
    private final String resourcePolicy;
    private final String version;

    private ManagedView(BuilderImpl builder) {
        this.managedViewArn = builder.managedViewArn;
        this.managedViewName = builder.managedViewName;
        this.trustedService = builder.trustedService;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.owner = builder.owner;
        this.scope = builder.scope;
        this.includedProperties = builder.includedProperties;
        this.filters = builder.filters;
        this.resourcePolicy = builder.resourcePolicy;
        this.version = builder.version;
    }

    public final String managedViewArn() {
        return this.managedViewArn;
    }

    public final String managedViewName() {
        return this.managedViewName;
    }

    public final String trustedService() {
        return this.trustedService;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String owner() {
        return this.owner;
    }

    public final String scope() {
        return this.scope;
    }

    public final boolean hasIncludedProperties() {
        return this.includedProperties != null && !(this.includedProperties instanceof SdkAutoConstructList);
    }

    public final List<IncludedProperty> includedProperties() {
        return this.includedProperties;
    }

    public final SearchFilter filters() {
        return this.filters;
    }

    public final String resourcePolicy() {
        return this.resourcePolicy;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedViewName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedService());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedProperties() ? this.includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedView)) {
            return false;
        }
        ManagedView other = (ManagedView)obj;
        return Objects.equals(this.managedViewArn(), other.managedViewArn()) && Objects.equals(this.managedViewName(), other.managedViewName()) && Objects.equals(this.trustedService(), other.trustedService()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.scope(), other.scope()) && this.hasIncludedProperties() == other.hasIncludedProperties() && Objects.equals(this.includedProperties(), other.includedProperties()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedView").add("ManagedViewArn", (Object)this.managedViewArn()).add("ManagedViewName", (Object)this.managedViewName()).add("TrustedService", (Object)this.trustedService()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Owner", (Object)this.owner()).add("Scope", (Object)this.scope()).add("IncludedProperties", this.hasIncludedProperties() ? this.includedProperties() : null).add("Filters", (Object)(this.filters() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourcePolicy", (Object)this.resourcePolicy()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedViewArn": {
                return Optional.ofNullable(clazz.cast(this.managedViewArn()));
            }
            case "ManagedViewName": {
                return Optional.ofNullable(clazz.cast(this.managedViewName()));
            }
            case "TrustedService": {
                return Optional.ofNullable(clazz.cast(this.trustedService()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "IncludedProperties": {
                return Optional.ofNullable(clazz.cast(this.includedProperties()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedViewArn", MANAGED_VIEW_ARN_FIELD);
        map.put("ManagedViewName", MANAGED_VIEW_NAME_FIELD);
        map.put("TrustedService", TRUSTED_SERVICE_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("IncludedProperties", INCLUDED_PROPERTIES_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedView, T> g) {
        return obj -> g.apply((ManagedView)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String managedViewArn;
        private String managedViewName;
        private String trustedService;
        private Instant lastUpdatedAt;
        private String owner;
        private String scope;
        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();
        private SearchFilter filters;
        private String resourcePolicy;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedView model) {
            this.managedViewArn(model.managedViewArn);
            this.managedViewName(model.managedViewName);
            this.trustedService(model.trustedService);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.owner(model.owner);
            this.scope(model.scope);
            this.includedProperties(model.includedProperties);
            this.filters(model.filters);
            this.resourcePolicy(model.resourcePolicy);
            this.version(model.version);
        }

        public final String getManagedViewArn() {
            return this.managedViewArn;
        }

        public final void setManagedViewArn(String managedViewArn) {
            this.managedViewArn = managedViewArn;
        }

        @Override
        public final Builder managedViewArn(String managedViewArn) {
            this.managedViewArn = managedViewArn;
            return this;
        }

        public final String getManagedViewName() {
            return this.managedViewName;
        }

        public final void setManagedViewName(String managedViewName) {
            this.managedViewName = managedViewName;
        }

        @Override
        public final Builder managedViewName(String managedViewName) {
            this.managedViewName = managedViewName;
            return this;
        }

        public final String getTrustedService() {
            return this.trustedService;
        }

        public final void setTrustedService(String trustedService) {
            this.trustedService = trustedService;
        }

        @Override
        public final Builder trustedService(String trustedService) {
            this.trustedService = trustedService;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty ... includedProperties) {
            this.includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder> ... includedProperties) {
            this.includedProperties(Stream.of(includedProperties).map(c -> (IncludedProperty)((IncludedProperty.Builder)IncludedProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SearchFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public ManagedView build() {
            return new ManagedView(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedView> {
        public Builder managedViewArn(String var1);

        public Builder managedViewName(String var1);

        public Builder trustedService(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder owner(String var1);

        public Builder scope(String var1);

        public Builder includedProperties(Collection<IncludedProperty> var1);

        public Builder includedProperties(IncludedProperty ... var1);

        public Builder includedProperties(Consumer<IncludedProperty.Builder> ... var1);

        public Builder filters(SearchFilter var1);

        default public Builder filters(Consumer<SearchFilter.Builder> filters) {
            return this.filters((SearchFilter)((SearchFilter.Builder)SearchFilter.builder().applyMutation(filters)).build());
        }

        public Builder resourcePolicy(String var1);

        public Builder version(String var1);
    }
}

