/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewInputViewArnsListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetViewRequest
extends ResourceExplorer2Request
implements ToCopyableBuilder<Builder, BatchGetViewRequest> {
    private static final SdkField<List<String>> VIEW_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViewArns").getter(BatchGetViewRequest.getter(BatchGetViewRequest::viewArns)).setter(BatchGetViewRequest.setter(Builder::viewArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIEW_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetViewRequest.memberNameToFieldInitializer();
    private final List<String> viewArns;

    private BatchGetViewRequest(BuilderImpl builder) {
        super(builder);
        this.viewArns = builder.viewArns;
    }

    public final boolean hasViewArns() {
        return this.viewArns != null && !(this.viewArns instanceof SdkAutoConstructList);
    }

    public final List<String> viewArns() {
        return this.viewArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViewArns() ? this.viewArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetViewRequest)) {
            return false;
        }
        BatchGetViewRequest other = (BatchGetViewRequest)((Object)obj);
        return this.hasViewArns() == other.hasViewArns() && Objects.equals(this.viewArns(), other.viewArns());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetViewRequest").add("ViewArns", this.hasViewArns() ? this.viewArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViewArns": {
                return Optional.ofNullable(clazz.cast(this.viewArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ViewArns", VIEW_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetViewRequest, T> g) {
        return obj -> g.apply((BatchGetViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Request.BuilderImpl
    implements Builder {
        private List<String> viewArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetViewRequest model) {
            super(model);
            this.viewArns(model.viewArns);
        }

        public final Collection<String> getViewArns() {
            if (this.viewArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.viewArns;
        }

        public final void setViewArns(Collection<String> viewArns) {
            this.viewArns = BatchGetViewInputViewArnsListCopier.copy(viewArns);
        }

        @Override
        public final Builder viewArns(Collection<String> viewArns) {
            this.viewArns = BatchGetViewInputViewArnsListCopier.copy(viewArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewArns(String ... viewArns) {
            this.viewArns(Arrays.asList(viewArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetViewRequest build() {
            return new BatchGetViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceExplorer2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetViewRequest> {
        public Builder viewArns(Collection<String> var1);

        public Builder viewArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

