/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourceexplorer2.model.IndexState;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIndexResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, CreateIndexResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateIndexResponse.getter(CreateIndexResponse::arn)).setter(CreateIndexResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateIndexResponse.getter(CreateIndexResponse::createdAt)).setter(CreateIndexResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateIndexResponse.getter(CreateIndexResponse::stateAsString)).setter(CreateIndexResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIndexResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant createdAt;
    private final String state;

    private CreateIndexResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final IndexState state() {
        return IndexState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexResponse)) {
            return false;
        }
        CreateIndexResponse other = (CreateIndexResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIndexResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexResponse, T> g) {
        return obj -> g.apply((CreateIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IndexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateIndexResponse build() {
            return new CreateIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIndexResponse> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder state(String var1);

        public Builder state(IndexState var1);
    }
}

