/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A search filter defines which resources can be part of a search query result set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFilter implements SdkPojo, Serializable, ToCopyableBuilder<SearchFilter.Builder, SearchFilter> {
    private static final SdkField<String> FILTER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterString").getter(getter(SearchFilter::filterString)).setter(setter(Builder::filterString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterString;

    private SearchFilter(BuilderImpl builder) {
        this.filterString = builder.filterString;
    }

    /**
     * <p>
     * The string that contains the search keywords, prefixes, and operators to control the results that can be returned
     * by a <a>Search</a> operation. For more details, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax</a>.
     * </p>
     * 
     * @return The string that contains the search keywords, prefixes, and operators to control the results that can be
     *         returned by a <a>Search</a> operation. For more details, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search
     *         query syntax</a>.
     */
    public final String filterString() {
        return filterString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFilter)) {
            return false;
        }
        SearchFilter other = (SearchFilter) obj;
        return Objects.equals(filterString(), other.filterString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchFilter").add("FilterString", filterString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterString":
            return Optional.ofNullable(clazz.cast(filterString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFilter, T> g) {
        return obj -> g.apply((SearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchFilter> {
        /**
         * <p>
         * The string that contains the search keywords, prefixes, and operators to control the results that can be
         * returned by a <a>Search</a> operation. For more details, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
         * syntax</a>.
         * </p>
         * 
         * @param filterString
         *        The string that contains the search keywords, prefixes, and operators to control the results that can
         *        be returned by a <a>Search</a> operation. For more details, see <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html"
         *        >Search query syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterString(String filterString);
    }

    static final class BuilderImpl implements Builder {
        private String filterString;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFilter model) {
            filterString(model.filterString);
        }

        public final String getFilterString() {
            return filterString;
        }

        public final void setFilterString(String filterString) {
            this.filterString = filterString;
        }

        @Override
        public final Builder filterString(String filterString) {
            this.filterString = filterString;
            return this;
        }

        @Override
        public SearchFilter build() {
            return new SearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
