/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIndexResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<CreateIndexResponse.Builder, CreateIndexResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateIndexResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateIndexResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateIndexResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            STATE_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final String state;

    private CreateIndexResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ARN of the new local index for the Region. You can reference this ARN in IAM permission policies to authorize
     * the following operations: <a>DeleteIndex</a> | <a>GetIndex</a> | <a>UpdateIndexType</a> | <a>CreateView</a>
     * </p>
     * 
     * @return The ARN of the new local index for the Region. You can reference this ARN in IAM permission policies to
     *         authorize the following operations: <a>DeleteIndex</a> | <a>GetIndex</a> | <a>UpdateIndexType</a> |
     *         <a>CreateView</a>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and timestamp when the index was created.
     * </p>
     * 
     * @return The date and timestamp when the index was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates the current state of the index. You can check for changes to the state for asynchronous operations by
     * calling the <a>GetIndex</a> operation.
     * </p>
     * <note>
     * <p>
     * The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as Resource
     * Explorer discovers the information about your resources and populates the index.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the current state of the index. You can check for changes to the state for asynchronous
     *         operations by calling the <a>GetIndex</a> operation.</p> <note>
     *         <p>
     *         The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
     *         Resource Explorer discovers the information about your resources and populates the index.
     *         </p>
     * @see IndexState
     */
    public final IndexState state() {
        return IndexState.fromValue(state);
    }

    /**
     * <p>
     * Indicates the current state of the index. You can check for changes to the state for asynchronous operations by
     * calling the <a>GetIndex</a> operation.
     * </p>
     * <note>
     * <p>
     * The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as Resource
     * Explorer discovers the information about your resources and populates the index.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the current state of the index. You can check for changes to the state for asynchronous
     *         operations by calling the <a>GetIndex</a> operation.</p> <note>
     *         <p>
     *         The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
     *         Resource Explorer discovers the information about your resources and populates the index.
     *         </p>
     * @see IndexState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexResponse)) {
            return false;
        }
        CreateIndexResponse other = (CreateIndexResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIndexResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexResponse, T> g) {
        return obj -> g.apply((CreateIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateIndexResponse> {
        /**
         * <p>
         * The ARN of the new local index for the Region. You can reference this ARN in IAM permission policies to
         * authorize the following operations: <a>DeleteIndex</a> | <a>GetIndex</a> | <a>UpdateIndexType</a> |
         * <a>CreateView</a>
         * </p>
         * 
         * @param arn
         *        The ARN of the new local index for the Region. You can reference this ARN in IAM permission policies
         *        to authorize the following operations: <a>DeleteIndex</a> | <a>GetIndex</a> | <a>UpdateIndexType</a> |
         *        <a>CreateView</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and timestamp when the index was created.
         * </p>
         * 
         * @param createdAt
         *        The date and timestamp when the index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates the current state of the index. You can check for changes to the state for asynchronous operations
         * by calling the <a>GetIndex</a> operation.
         * </p>
         * <note>
         * <p>
         * The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
         * Resource Explorer discovers the information about your resources and populates the index.
         * </p>
         * </note>
         * 
         * @param state
         *        Indicates the current state of the index. You can check for changes to the state for asynchronous
         *        operations by calling the <a>GetIndex</a> operation.</p> <note>
         *        <p>
         *        The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
         *        Resource Explorer discovers the information about your resources and populates the index.
         *        </p>
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates the current state of the index. You can check for changes to the state for asynchronous operations
         * by calling the <a>GetIndex</a> operation.
         * </p>
         * <note>
         * <p>
         * The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
         * Resource Explorer discovers the information about your resources and populates the index.
         * </p>
         * </note>
         * 
         * @param state
         *        Indicates the current state of the index. You can check for changes to the state for asynchronous
         *        operations by calling the <a>GetIndex</a> operation.</p> <note>
         *        <p>
         *        The state can remain in the <code>CREATING</code> or <code>UPDATING</code> state for several hours as
         *        Resource Explorer discovers the information about your resources and populates the index.
         *        </p>
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(IndexState state);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IndexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateIndexResponse build() {
            return new CreateIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
