/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSpacesResponse extends RepostspaceResponse implements
        ToCopyableBuilder<ListSpacesResponse.Builder, ListSpacesResponse> {
    private static final SdkField<List<SpaceData>> SPACES_FIELD = SdkField
            .<List<SpaceData>> builder(MarshallingType.LIST)
            .memberName("spaces")
            .getter(getter(ListSpacesResponse::spaces))
            .setter(setter(Builder::spaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpaceData> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpaceData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSpacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SPACES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SpaceData> spaces;

    private final String nextToken;

    private ListSpacesResponse(BuilderImpl builder) {
        super(builder);
        this.spaces = builder.spaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSpaces() {
        return spaces != null && !(spaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain some information about the private re:Posts in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpaces} method.
     * </p>
     * 
     * @return An array of structures that contain some information about the private re:Posts in the account.
     */
    public final List<SpaceData> spaces() {
        return spaces;
    }

    /**
     * <p>
     * The token that you use when you request the next set of private re:Posts.
     * </p>
     * 
     * @return The token that you use when you request the next set of private re:Posts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSpaces() ? spaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpacesResponse)) {
            return false;
        }
        ListSpacesResponse other = (ListSpacesResponse) obj;
        return hasSpaces() == other.hasSpaces() && Objects.equals(spaces(), other.spaces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSpacesResponse").add("Spaces", hasSpaces() ? spaces() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaces":
            return Optional.ofNullable(clazz.cast(spaces()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spaces", SPACES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpacesResponse, T> g) {
        return obj -> g.apply((ListSpacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RepostspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSpacesResponse> {
        /**
         * <p>
         * An array of structures that contain some information about the private re:Posts in the account.
         * </p>
         * 
         * @param spaces
         *        An array of structures that contain some information about the private re:Posts in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaces(Collection<SpaceData> spaces);

        /**
         * <p>
         * An array of structures that contain some information about the private re:Posts in the account.
         * </p>
         * 
         * @param spaces
         *        An array of structures that contain some information about the private re:Posts in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaces(SpaceData... spaces);

        /**
         * <p>
         * An array of structures that contain some information about the private re:Posts in the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.repostspace.model.SpaceData.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.repostspace.model.SpaceData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.repostspace.model.SpaceData.Builder#build()} is called immediately and
         * its result is passed to {@link #spaces(List<SpaceData>)}.
         * 
         * @param spaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.repostspace.model.SpaceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaces(java.util.Collection<SpaceData>)
         */
        Builder spaces(Consumer<SpaceData.Builder>... spaces);

        /**
         * <p>
         * The token that you use when you request the next set of private re:Posts.
         * </p>
         * 
         * @param nextToken
         *        The token that you use when you request the next set of private re:Posts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RepostspaceResponse.BuilderImpl implements Builder {
        private List<SpaceData> spaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpacesResponse model) {
            super(model);
            spaces(model.spaces);
            nextToken(model.nextToken);
        }

        public final List<SpaceData.Builder> getSpaces() {
            List<SpaceData.Builder> result = SpacesListCopier.copyToBuilder(this.spaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpaces(Collection<SpaceData.BuilderImpl> spaces) {
            this.spaces = SpacesListCopier.copyFromBuilder(spaces);
        }

        @Override
        public final Builder spaces(Collection<SpaceData> spaces) {
            this.spaces = SpacesListCopier.copy(spaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(SpaceData... spaces) {
            spaces(Arrays.asList(spaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(Consumer<SpaceData.Builder>... spaces) {
            spaces(Stream.of(spaces).map(c -> SpaceData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSpacesResponse build() {
            return new ListSpacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
