/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains some information about a channel in a private re:Post.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelData implements SdkPojo, Serializable, ToCopyableBuilder<ChannelData.Builder, ChannelData> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(ChannelData::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelId").getter(getter(ChannelData::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(ChannelData::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CHANNEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelDescription").getter(getter(ChannelData::channelDescription))
            .setter(setter(Builder::channelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelDescription").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createDateTime")
            .getter(getter(ChannelData::createDateTime))
            .setter(setter(Builder::createDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("deleteDateTime")
            .getter(getter(ChannelData::deleteDateTime))
            .setter(setter(Builder::deleteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CHANNEL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelStatus").getter(getter(ChannelData::channelStatusAsString))
            .setter(setter(Builder::channelStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStatus").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("userCount").getter(getter(ChannelData::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()).build();

    private static final SdkField<Integer> GROUP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("groupCount").getter(getter(ChannelData::groupCount)).setter(setter(Builder::groupCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD,
            CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, CHANNEL_DESCRIPTION_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD,
            CHANNEL_STATUS_FIELD, USER_COUNT_FIELD, GROUP_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String spaceId;

    private final String channelId;

    private final String channelName;

    private final String channelDescription;

    private final Instant createDateTime;

    private final Instant deleteDateTime;

    private final String channelStatus;

    private final Integer userCount;

    private final Integer groupCount;

    private ChannelData(BuilderImpl builder) {
        this.spaceId = builder.spaceId;
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.channelDescription = builder.channelDescription;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.channelStatus = builder.channelStatus;
        this.userCount = builder.userCount;
        this.groupCount = builder.groupCount;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The unique ID of the private re:Post channel.
     * </p>
     * 
     * @return The unique ID of the private re:Post channel.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * <p>
     * The name for the channel. This must be unique per private re:Post.
     * </p>
     * 
     * @return The name for the channel. This must be unique per private re:Post.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * A description for the channel. This is used only to help you identify this channel.
     * </p>
     * 
     * @return A description for the channel. This is used only to help you identify this channel.
     */
    public final String channelDescription() {
        return channelDescription;
    }

    /**
     * <p>
     * The date when the channel was created.
     * </p>
     * 
     * @return The date when the channel was created.
     */
    public final Instant createDateTime() {
        return createDateTime;
    }

    /**
     * <p>
     * The date when the channel was deleted.
     * </p>
     * 
     * @return The date when the channel was deleted.
     */
    public final Instant deleteDateTime() {
        return deleteDateTime;
    }

    /**
     * <p>
     * The status pf the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return The status pf the channel.
     * @see ChannelStatus
     */
    public final ChannelStatus channelStatus() {
        return ChannelStatus.fromValue(channelStatus);
    }

    /**
     * <p>
     * The status pf the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return The status pf the channel.
     * @see ChannelStatus
     */
    public final String channelStatusAsString() {
        return channelStatus;
    }

    /**
     * <p>
     * The number of users that are part of the channel.
     * </p>
     * 
     * @return The number of users that are part of the channel.
     */
    public final Integer userCount() {
        return userCount;
    }

    /**
     * <p>
     * The number of groups that are part of the channel.
     * </p>
     * 
     * @return The number of groups that are part of the channel.
     */
    public final Integer groupCount() {
        return groupCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(channelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        hashCode = 31 * hashCode + Objects.hashCode(groupCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelData)) {
            return false;
        }
        ChannelData other = (ChannelData) obj;
        return Objects.equals(spaceId(), other.spaceId()) && Objects.equals(channelId(), other.channelId())
                && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelDescription(), other.channelDescription())
                && Objects.equals(createDateTime(), other.createDateTime())
                && Objects.equals(deleteDateTime(), other.deleteDateTime())
                && Objects.equals(channelStatusAsString(), other.channelStatusAsString())
                && Objects.equals(userCount(), other.userCount()) && Objects.equals(groupCount(), other.groupCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelData").add("SpaceId", spaceId()).add("ChannelId", channelId())
                .add("ChannelName", channelName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelDescription", channelDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreateDateTime", createDateTime()).add("DeleteDateTime", deleteDateTime())
                .add("ChannelStatus", channelStatusAsString()).add("UserCount", userCount()).add("GroupCount", groupCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "channelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelDescription":
            return Optional.ofNullable(clazz.cast(channelDescription()));
        case "createDateTime":
            return Optional.ofNullable(clazz.cast(createDateTime()));
        case "deleteDateTime":
            return Optional.ofNullable(clazz.cast(deleteDateTime()));
        case "channelStatus":
            return Optional.ofNullable(clazz.cast(channelStatusAsString()));
        case "userCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        case "groupCount":
            return Optional.ofNullable(clazz.cast(groupCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("channelDescription", CHANNEL_DESCRIPTION_FIELD);
        map.put("createDateTime", CREATE_DATE_TIME_FIELD);
        map.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
        map.put("channelStatus", CHANNEL_STATUS_FIELD);
        map.put("userCount", USER_COUNT_FIELD);
        map.put("groupCount", GROUP_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelData, T> g) {
        return obj -> g.apply((ChannelData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelData> {
        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The unique ID of the private re:Post channel.
         * </p>
         * 
         * @param channelId
         *        The unique ID of the private re:Post channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * <p>
         * The name for the channel. This must be unique per private re:Post.
         * </p>
         * 
         * @param channelName
         *        The name for the channel. This must be unique per private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * A description for the channel. This is used only to help you identify this channel.
         * </p>
         * 
         * @param channelDescription
         *        A description for the channel. This is used only to help you identify this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDescription(String channelDescription);

        /**
         * <p>
         * The date when the channel was created.
         * </p>
         * 
         * @param createDateTime
         *        The date when the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDateTime(Instant createDateTime);

        /**
         * <p>
         * The date when the channel was deleted.
         * </p>
         * 
         * @param deleteDateTime
         *        The date when the channel was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDateTime(Instant deleteDateTime);

        /**
         * <p>
         * The status pf the channel.
         * </p>
         * 
         * @param channelStatus
         *        The status pf the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder channelStatus(String channelStatus);

        /**
         * <p>
         * The status pf the channel.
         * </p>
         * 
         * @param channelStatus
         *        The status pf the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder channelStatus(ChannelStatus channelStatus);

        /**
         * <p>
         * The number of users that are part of the channel.
         * </p>
         * 
         * @param userCount
         *        The number of users that are part of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);

        /**
         * <p>
         * The number of groups that are part of the channel.
         * </p>
         * 
         * @param groupCount
         *        The number of groups that are part of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCount(Integer groupCount);
    }

    static final class BuilderImpl implements Builder {
        private String spaceId;

        private String channelId;

        private String channelName;

        private String channelDescription;

        private Instant createDateTime;

        private Instant deleteDateTime;

        private String channelStatus;

        private Integer userCount;

        private Integer groupCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelData model) {
            spaceId(model.spaceId);
            channelId(model.channelId);
            channelName(model.channelName);
            channelDescription(model.channelDescription);
            createDateTime(model.createDateTime);
            deleteDateTime(model.deleteDateTime);
            channelStatus(model.channelStatus);
            userCount(model.userCount);
            groupCount(model.groupCount);
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelDescription() {
            return channelDescription;
        }

        public final void setChannelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
        }

        @Override
        public final Builder channelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
            return this;
        }

        public final Instant getCreateDateTime() {
            return createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getChannelStatus() {
            return channelStatus;
        }

        public final void setChannelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
        }

        @Override
        public final Builder channelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
            return this;
        }

        @Override
        public final Builder channelStatus(ChannelStatus channelStatus) {
            this.channelStatus(channelStatus == null ? null : channelStatus.toString());
            return this;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Integer getGroupCount() {
            return groupCount;
        }

        public final void setGroupCount(Integer groupCount) {
            this.groupCount = groupCount;
        }

        @Override
        public final Builder groupCount(Integer groupCount) {
            this.groupCount = groupCount;
            return this;
        }

        @Override
        public ChannelData build() {
            return new ChannelData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
