/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAddChannelRoleToAccessorsResponse extends RepostspaceResponse implements
        ToCopyableBuilder<BatchAddChannelRoleToAccessorsResponse.Builder, BatchAddChannelRoleToAccessorsResponse> {
    private static final SdkField<List<String>> ADDED_ACCESSOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("addedAccessorIds")
            .getter(getter(BatchAddChannelRoleToAccessorsResponse::addedAccessorIds))
            .setter(setter(Builder::addedAccessorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedAccessorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField
            .<List<BatchError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchAddChannelRoleToAccessorsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_ACCESSOR_IDS_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> addedAccessorIds;

    private final List<BatchError> errors;

    private BatchAddChannelRoleToAccessorsResponse(BuilderImpl builder) {
        super(builder);
        this.addedAccessorIds = builder.addedAccessorIds;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddedAccessorIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddedAccessorIds() {
        return addedAccessorIds != null && !(addedAccessorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of successfully updated identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddedAccessorIds} method.
     * </p>
     * 
     * @return An array of successfully updated identifiers.
     */
    public final List<String> addedAccessorIds() {
        return addedAccessorIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of errors that occurred when roles were added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of errors that occurred when roles were added.
     */
    public final List<BatchError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddedAccessorIds() ? addedAccessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddChannelRoleToAccessorsResponse)) {
            return false;
        }
        BatchAddChannelRoleToAccessorsResponse other = (BatchAddChannelRoleToAccessorsResponse) obj;
        return hasAddedAccessorIds() == other.hasAddedAccessorIds()
                && Objects.equals(addedAccessorIds(), other.addedAccessorIds()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAddChannelRoleToAccessorsResponse")
                .add("AddedAccessorIds", hasAddedAccessorIds() ? addedAccessorIds() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addedAccessorIds":
            return Optional.ofNullable(clazz.cast(addedAccessorIds()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addedAccessorIds", ADDED_ACCESSOR_IDS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddChannelRoleToAccessorsResponse, T> g) {
        return obj -> g.apply((BatchAddChannelRoleToAccessorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RepostspaceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAddChannelRoleToAccessorsResponse> {
        /**
         * <p>
         * An array of successfully updated identifiers.
         * </p>
         * 
         * @param addedAccessorIds
         *        An array of successfully updated identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedAccessorIds(Collection<String> addedAccessorIds);

        /**
         * <p>
         * An array of successfully updated identifiers.
         * </p>
         * 
         * @param addedAccessorIds
         *        An array of successfully updated identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedAccessorIds(String... addedAccessorIds);

        /**
         * <p>
         * An array of errors that occurred when roles were added.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when roles were added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchError> errors);

        /**
         * <p>
         * An array of errors that occurred when roles were added.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when roles were added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchError... errors);

        /**
         * <p>
         * An array of errors that occurred when roles were added.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.repostspace.model.BatchError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<BatchError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchError>)
         */
        Builder errors(Consumer<BatchError.Builder>... errors);
    }

    static final class BuilderImpl extends RepostspaceResponse.BuilderImpl implements Builder {
        private List<String> addedAccessorIds = DefaultSdkAutoConstructList.getInstance();

        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddChannelRoleToAccessorsResponse model) {
            super(model);
            addedAccessorIds(model.addedAccessorIds);
            errors(model.errors);
        }

        public final Collection<String> getAddedAccessorIds() {
            if (addedAccessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addedAccessorIds;
        }

        public final void setAddedAccessorIds(Collection<String> addedAccessorIds) {
            this.addedAccessorIds = AccessorIdListCopier.copy(addedAccessorIds);
        }

        @Override
        public final Builder addedAccessorIds(Collection<String> addedAccessorIds) {
            this.addedAccessorIds = AccessorIdListCopier.copy(addedAccessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedAccessorIds(String... addedAccessorIds) {
            addedAccessorIds(Arrays.asList(addedAccessorIds));
            return this;
        }

        public final List<BatchError.Builder> getErrors() {
            List<BatchError.Builder> result = BatchErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAddChannelRoleToAccessorsResponse build() {
            return new BatchAddChannelRoleToAccessorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
