/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterAdminRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, DeregisterAdminRequest> {
    private static final SdkField<String> ADMIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminId").getter(DeregisterAdminRequest.getter(DeregisterAdminRequest::adminId)).setter(DeregisterAdminRequest.setter(Builder::adminId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("adminId").build()}).build();
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(DeregisterAdminRequest.getter(DeregisterAdminRequest::spaceId)).setter(DeregisterAdminRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ID_FIELD, SPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeregisterAdminRequest.memberNameToFieldInitializer();
    private final String adminId;
    private final String spaceId;

    private DeregisterAdminRequest(BuilderImpl builder) {
        super(builder);
        this.adminId = builder.adminId;
        this.spaceId = builder.spaceId;
    }

    public final String adminId() {
        return this.adminId;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterAdminRequest)) {
            return false;
        }
        DeregisterAdminRequest other = (DeregisterAdminRequest)((Object)obj);
        return Objects.equals(this.adminId(), other.adminId()) && Objects.equals(this.spaceId(), other.spaceId());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterAdminRequest").add("AdminId", (Object)this.adminId()).add("SpaceId", (Object)this.spaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminId": {
                return Optional.ofNullable(clazz.cast(this.adminId()));
            }
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("adminId", ADMIN_ID_FIELD);
        map.put("spaceId", SPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterAdminRequest, T> g) {
        return obj -> g.apply((DeregisterAdminRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private String adminId;
        private String spaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterAdminRequest model) {
            super(model);
            this.adminId(model.adminId);
            this.spaceId(model.spaceId);
        }

        public final String getAdminId() {
            return this.adminId;
        }

        public final void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        @Override
        public final Builder adminId(String adminId) {
            this.adminId = adminId;
            return this;
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterAdminRequest build() {
            return new DeregisterAdminRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterAdminRequest> {
        public Builder adminId(String var1);

        public Builder spaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

