/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.AccessorIdListCopier;
import software.amazon.awssdk.services.repostspace.model.BatchError;
import software.amazon.awssdk.services.repostspace.model.BatchErrorListCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchRemoveRoleResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, BatchRemoveRoleResponse> {
    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchRemoveRoleResponse.getter(BatchRemoveRoleResponse::errors)).setter(BatchRemoveRoleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVED_ACCESSOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removedAccessorIds").getter(BatchRemoveRoleResponse.getter(BatchRemoveRoleResponse::removedAccessorIds)).setter(BatchRemoveRoleResponse.setter(Builder::removedAccessorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removedAccessorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, REMOVED_ACCESSOR_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errors", ERRORS_FIELD);
            this.put("removedAccessorIds", REMOVED_ACCESSOR_IDS_FIELD);
        }
    });
    private final List<BatchError> errors;
    private final List<String> removedAccessorIds;

    private BatchRemoveRoleResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.removedAccessorIds = builder.removedAccessorIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchError> errors() {
        return this.errors;
    }

    public final boolean hasRemovedAccessorIds() {
        return this.removedAccessorIds != null && !(this.removedAccessorIds instanceof SdkAutoConstructList);
    }

    public final List<String> removedAccessorIds() {
        return this.removedAccessorIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemovedAccessorIds() ? this.removedAccessorIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRemoveRoleResponse)) {
            return false;
        }
        BatchRemoveRoleResponse other = (BatchRemoveRoleResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasRemovedAccessorIds() == other.hasRemovedAccessorIds() && Objects.equals(this.removedAccessorIds(), other.removedAccessorIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchRemoveRoleResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("RemovedAccessorIds", this.hasRemovedAccessorIds() ? this.removedAccessorIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "removedAccessorIds": {
                return Optional.ofNullable(clazz.cast(this.removedAccessorIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchRemoveRoleResponse, T> g) {
        return obj -> g.apply((BatchRemoveRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> removedAccessorIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRemoveRoleResponse model) {
            super(model);
            this.errors(model.errors);
            this.removedAccessorIds(model.removedAccessorIds);
        }

        public final List<BatchError.Builder> getErrors() {
            List<BatchError.Builder> result = BatchErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchError)((BatchError.Builder)BatchError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemovedAccessorIds() {
            if (this.removedAccessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removedAccessorIds;
        }

        public final void setRemovedAccessorIds(Collection<String> removedAccessorIds) {
            this.removedAccessorIds = AccessorIdListCopier.copy(removedAccessorIds);
        }

        @Override
        public final Builder removedAccessorIds(Collection<String> removedAccessorIds) {
            this.removedAccessorIds = AccessorIdListCopier.copy(removedAccessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedAccessorIds(String ... removedAccessorIds) {
            this.removedAccessorIds(Arrays.asList(removedAccessorIds));
            return this;
        }

        @Override
        public BatchRemoveRoleResponse build() {
            return new BatchRemoveRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchRemoveRoleResponse> {
        public Builder errors(Collection<BatchError> var1);

        public Builder errors(BatchError ... var1);

        public Builder errors(Consumer<BatchError.Builder> ... var1);

        public Builder removedAccessorIds(Collection<String> var1);

        public Builder removedAccessorIds(String ... var1);
    }
}

