/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.services.repostspace.model.SpaceData;
import software.amazon.awssdk.services.repostspace.model.SpacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSpacesResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, ListSpacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSpacesResponse.getter(ListSpacesResponse::nextToken)).setter(ListSpacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SpaceData>> SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("spaces").getter(ListSpacesResponse.getter(ListSpacesResponse::spaces)).setter(ListSpacesResponse.setter(Builder::spaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpaceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("spaces", SPACES_FIELD);
        }
    });
    private final String nextToken;
    private final List<SpaceData> spaces;

    private ListSpacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spaces = builder.spaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSpaces() {
        return this.spaces != null && !(this.spaces instanceof SdkAutoConstructList);
    }

    public final List<SpaceData> spaces() {
        return this.spaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpaces() ? this.spaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpacesResponse)) {
            return false;
        }
        ListSpacesResponse other = (ListSpacesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSpaces() == other.hasSpaces() && Objects.equals(this.spaces(), other.spaces());
    }

    public final String toString() {
        return ToString.builder((String)"ListSpacesResponse").add("NextToken", (Object)this.nextToken()).add("Spaces", this.hasSpaces() ? this.spaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "spaces": {
                return Optional.ofNullable(clazz.cast(this.spaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSpacesResponse, T> g) {
        return obj -> g.apply((ListSpacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SpaceData> spaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpacesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.spaces(model.spaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SpaceData.Builder> getSpaces() {
            List<SpaceData.Builder> result = SpacesListCopier.copyToBuilder(this.spaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpaces(Collection<SpaceData.BuilderImpl> spaces) {
            this.spaces = SpacesListCopier.copyFromBuilder(spaces);
        }

        @Override
        public final Builder spaces(Collection<SpaceData> spaces) {
            this.spaces = SpacesListCopier.copy(spaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(SpaceData ... spaces) {
            this.spaces(Arrays.asList(spaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(Consumer<SpaceData.Builder> ... spaces) {
            this.spaces(Stream.of(spaces).map(c -> (SpaceData)((SpaceData.Builder)SpaceData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSpacesResponse build() {
            return new ListSpacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSpacesResponse> {
        public Builder nextToken(String var1);

        public Builder spaces(Collection<SpaceData> var1);

        public Builder spaces(SpaceData ... var1);

        public Builder spaces(Consumer<SpaceData.Builder> ... var1);
    }
}

