/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.release.Cli;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public class UpdateServiceMain
extends Cli {
    private static final Logger log = Logger.loggerFor(UpdateServiceMain.class);

    private UpdateServiceMain() {
        super(UpdateServiceMain.requiredOption("service-module-name", "The name of the service module to be created."), UpdateServiceMain.requiredOption("service-id", "The service ID of the service to be updated."), UpdateServiceMain.requiredOption("maven-project-root", "The root directory for the maven project."), UpdateServiceMain.requiredOption("service-json", "The service-2.json file for the service."), UpdateServiceMain.optionalOption("paginators-json", "The paginators-1.json file for the service."), UpdateServiceMain.optionalOption("waiters-json", "The waiters-2.json file for the service."));
    }

    public static void main(String[] args) {
        new UpdateServiceMain().run(args);
    }

    @Override
    protected void run(CommandLine commandLine) throws Exception {
        new ServiceUpdater(commandLine).run();
    }

    private static class ServiceUpdater {
        private final String serviceModuleName;
        private final String serviceId;
        private final Path mavenProjectRoot;
        private final Path serviceJson;
        private final Path paginatorsJson;
        private final Path waitersJson;

        private ServiceUpdater(CommandLine commandLine) {
            this.mavenProjectRoot = Paths.get(commandLine.getOptionValue("maven-project-root").trim(), new String[0]);
            this.serviceId = commandLine.getOptionValue("service-id").trim();
            this.serviceModuleName = commandLine.getOptionValue("service-module-name").trim();
            this.serviceJson = Paths.get(commandLine.getOptionValue("service-json").trim(), new String[0]);
            this.paginatorsJson = this.optionalPath(commandLine.getOptionValue("paginators-json"));
            this.waitersJson = this.optionalPath(commandLine.getOptionValue("waiters-json"));
        }

        private Path optionalPath(String path) {
            if ((path = StringUtils.trimToNull((String)path)) != null) {
                return Paths.get(path, new String[0]);
            }
            return null;
        }

        public void run() throws Exception {
            Validate.isTrue((boolean)Files.isRegularFile(this.serviceJson, new LinkOption[0]), (String)(this.serviceJson + " is not a file."), (Object[])new Object[0]);
            Path codegenFileLocation = this.codegenFileLocation(this.serviceModuleName, this.serviceId);
            this.copyFile(this.serviceJson, codegenFileLocation.resolve("service-2.json"));
            this.copyFile(this.paginatorsJson, codegenFileLocation.resolve("paginators-1.json"));
            this.copyFile(this.waitersJson, codegenFileLocation.resolve("waiters-2.json"));
        }

        private Path codegenFileLocation(String serviceModuleName, String serviceId) {
            Path codegenPath = this.mavenProjectRoot.resolve("services").resolve(serviceModuleName).resolve("src").resolve("main").resolve("resources").resolve("codegen-resources");
            switch (serviceId) {
                case "WAF Regional": {
                    return codegenPath.resolve("wafregional");
                }
                case "WAF": {
                    return codegenPath.resolve("waf");
                }
                case "DynamoDB Streams": {
                    return codegenPath.resolve("dynamodbstreams");
                }
                case "DynamoDB": {
                    return codegenPath.resolve("dynamodb");
                }
            }
            return codegenPath;
        }

        private void copyFile(Path source, Path destination) throws IOException {
            if (source != null && Files.isRegularFile(source, new LinkOption[0])) {
                log.info(() -> "Copying " + source + " to " + destination);
                FileUtils.copyFile((File)source.toFile(), (File)destination.toFile());
            }
        }
    }
}

