/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompareFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, CompareFacesRequest> {
    private static final SdkField<Image> SOURCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CompareFacesRequest.getter(CompareFacesRequest::sourceImage)).setter(CompareFacesRequest.setter(Builder::sourceImage)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImage").build()}).build();
    private static final SdkField<Image> TARGET_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CompareFacesRequest.getter(CompareFacesRequest::targetImage)).setter(CompareFacesRequest.setter(Builder::targetImage)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetImage").build()}).build();
    private static final SdkField<Float> SIMILARITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(CompareFacesRequest.getter(CompareFacesRequest::similarityThreshold)).setter(CompareFacesRequest.setter(Builder::similarityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimilarityThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FIELD, TARGET_IMAGE_FIELD, SIMILARITY_THRESHOLD_FIELD));
    private final Image sourceImage;
    private final Image targetImage;
    private final Float similarityThreshold;

    private CompareFacesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
    }

    public Image sourceImage() {
        return this.sourceImage;
    }

    public Image targetImage() {
        return this.targetImage;
    }

    public Float similarityThreshold() {
        return this.similarityThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.similarityThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest)((Object)obj);
        return Objects.equals(this.sourceImage(), other.sourceImage()) && Objects.equals(this.targetImage(), other.targetImage()) && Objects.equals(this.similarityThreshold(), other.similarityThreshold());
    }

    public String toString() {
        return ToString.builder((String)"CompareFacesRequest").add("SourceImage", (Object)this.sourceImage()).add("TargetImage", (Object)this.targetImage()).add("SimilarityThreshold", (Object)this.similarityThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImage": {
                return Optional.ofNullable(clazz.cast(this.sourceImage()));
            }
            case "TargetImage": {
                return Optional.ofNullable(clazz.cast(this.targetImage()));
            }
            case "SimilarityThreshold": {
                return Optional.ofNullable(clazz.cast(this.similarityThreshold()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesRequest, T> g) {
        return obj -> g.apply((CompareFacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image sourceImage;
        private Image targetImage;
        private Float similarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            super(model);
            this.sourceImage(model.sourceImage);
            this.targetImage(model.targetImage);
            this.similarityThreshold(model.similarityThreshold);
        }

        public final Image.Builder getSourceImage() {
            return this.sourceImage != null ? this.sourceImage.toBuilder() : null;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final void setSourceImage(Image.BuilderImpl sourceImage) {
            this.sourceImage = sourceImage != null ? sourceImage.build() : null;
        }

        public final Image.Builder getTargetImage() {
            return this.targetImage != null ? this.targetImage.toBuilder() : null;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final void setTargetImage(Image.BuilderImpl targetImage) {
            this.targetImage = targetImage != null ? targetImage.build() : null;
        }

        public final Float getSimilarityThreshold() {
            return this.similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompareFacesRequest> {
        public Builder sourceImage(Image var1);

        default public Builder sourceImage(Consumer<Image.Builder> sourceImage) {
            return this.sourceImage((Image)((Image.Builder)Image.builder().applyMutation(sourceImage)).build());
        }

        public Builder targetImage(Image var1);

        default public Builder targetImage(Consumer<Image.Builder> targetImage) {
            return this.targetImage((Image)((Image.Builder)Image.builder().applyMutation(targetImage)).build());
        }

        public Builder similarityThreshold(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

