/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.Reason;
import software.amazon.awssdk.services.rekognition.model.ReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnindexedFace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnindexedFace> {
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UnindexedFace.getter(UnindexedFace::reasonsAsStrings)).setter(UnindexedFace.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FaceDetail> FACE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UnindexedFace.getter(UnindexedFace::faceDetail)).setter(UnindexedFace.setter(Builder::faceDetail)).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONS_FIELD, FACE_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> reasons;
    private final FaceDetail faceDetail;

    private UnindexedFace(BuilderImpl builder) {
        this.reasons = builder.reasons;
        this.faceDetail = builder.faceDetail;
    }

    public List<Reason> reasons() {
        return ReasonsCopier.copyStringToEnum(this.reasons);
    }

    public List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public FaceDetail faceDetail() {
        return this.faceDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnindexedFace)) {
            return false;
        }
        UnindexedFace other = (UnindexedFace)obj;
        return Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings()) && Objects.equals(this.faceDetail(), other.faceDetail());
    }

    public String toString() {
        return ToString.builder((String)"UnindexedFace").add("Reasons", this.reasonsAsStrings()).add("FaceDetail", (Object)this.faceDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
            case "FaceDetail": {
                return Optional.ofNullable(clazz.cast(this.faceDetail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnindexedFace, T> g) {
        return obj -> g.apply((UnindexedFace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();
        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UnindexedFace model) {
            this.reasonsWithStrings(model.reasons);
            this.faceDetail(model.faceDetail);
        }

        public final Collection<String> getReasonsAsStrings() {
            return this.reasons;
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = ReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<Reason> reasons) {
            this.reasons = ReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Reason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        public final void setReasonsWithStrings(Collection<String> reasons) {
            this.reasons = ReasonsCopier.copy(reasons);
        }

        public final FaceDetail.Builder getFaceDetail() {
            return this.faceDetail != null ? this.faceDetail.toBuilder() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        public UnindexedFace build() {
            return new UnindexedFace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnindexedFace> {
        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<Reason> var1);

        public Builder reasons(Reason ... var1);

        public Builder faceDetail(FaceDetail var1);

        default public Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return this.faceDetail((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(faceDetail)).build());
        }
    }
}

