/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(FaceDetection.getter(FaceDetection::timestamp)).setter(FaceDetection.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FaceDetection.getter(FaceDetection::face)).setter(FaceDetection.setter(Builder::face)).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, FACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final FaceDetail face;

    private FaceDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.face = builder.face;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public FaceDetail face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetection)) {
            return false;
        }
        FaceDetection other = (FaceDetection)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.face(), other.face());
    }

    public String toString() {
        return ToString.builder((String)"FaceDetection").add("Timestamp", (Object)this.timestamp()).add("Face", (Object)this.face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceDetection, T> g) {
        return obj -> g.apply((FaceDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetection model) {
            this.timestamp(model.timestamp);
            this.face(model.face);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final FaceDetail.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public FaceDetection build() {
            return new FaceDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceDetection> {
        public Builder timestamp(Long var1);

        public Builder face(FaceDetail var1);

        default public Builder face(Consumer<FaceDetail.Builder> face) {
            return this.face((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(face)).build());
        }
    }
}

