/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.ChallengeType;
import software.amazon.awssdk.services.rekognition.model.Versions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChallengePreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChallengePreference> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ChallengePreference.getter(ChallengePreference::typeAsString)).setter(ChallengePreference.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Versions> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Versions").getter(ChallengePreference.getter(ChallengePreference::versions)).setter(ChallengePreference.setter(Builder::versions)).constructor(Versions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChallengePreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Versions versions;

    private ChallengePreference(BuilderImpl builder) {
        this.type = builder.type;
        this.versions = builder.versions;
    }

    public final ChallengeType type() {
        return ChallengeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Versions versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengePreference)) {
            return false;
        }
        ChallengePreference other = (ChallengePreference)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.versions(), other.versions());
    }

    public final String toString() {
        return ToString.builder((String)"ChallengePreference").add("Type", (Object)this.typeAsString()).add("Versions", (Object)this.versions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Versions", VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChallengePreference, T> g) {
        return obj -> g.apply((ChallengePreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Versions versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengePreference model) {
            this.type(model.type);
            this.versions(model.versions);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChallengeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Versions.Builder getVersions() {
            return this.versions != null ? this.versions.toBuilder() : null;
        }

        public final void setVersions(Versions.BuilderImpl versions) {
            this.versions = versions != null ? versions.build() : null;
        }

        @Override
        public final Builder versions(Versions versions) {
            this.versions = versions;
            return this;
        }

        public ChallengePreference build() {
            return new ChallengePreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChallengePreference> {
        public Builder type(String var1);

        public Builder type(ChallengeType var1);

        public Builder versions(Versions var1);

        default public Builder versions(Consumer<Versions.Builder> versions) {
            return this.versions((Versions)((Versions.Builder)Versions.builder().applyMutation(versions)).build());
        }
    }
}

