/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPersonsCopier;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectProtectiveEquipmentResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectProtectiveEquipmentResponse> {
    private static final SdkField<String> PROTECTIVE_EQUIPMENT_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectiveEquipmentModelVersion").getter(DetectProtectiveEquipmentResponse.getter(DetectProtectiveEquipmentResponse::protectiveEquipmentModelVersion)).setter(DetectProtectiveEquipmentResponse.setter(Builder::protectiveEquipmentModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectiveEquipmentModelVersion").build()}).build();
    private static final SdkField<List<ProtectiveEquipmentPerson>> PERSONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Persons").getter(DetectProtectiveEquipmentResponse.getter(DetectProtectiveEquipmentResponse::persons)).setter(DetectProtectiveEquipmentResponse.setter(Builder::persons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectiveEquipmentPerson::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProtectiveEquipmentSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(DetectProtectiveEquipmentResponse.getter(DetectProtectiveEquipmentResponse::summary)).setter(DetectProtectiveEquipmentResponse.setter(Builder::summary)).constructor(ProtectiveEquipmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTIVE_EQUIPMENT_MODEL_VERSION_FIELD, PERSONS_FIELD, SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectProtectiveEquipmentResponse.memberNameToFieldInitializer();
    private final String protectiveEquipmentModelVersion;
    private final List<ProtectiveEquipmentPerson> persons;
    private final ProtectiveEquipmentSummary summary;

    private DetectProtectiveEquipmentResponse(BuilderImpl builder) {
        super(builder);
        this.protectiveEquipmentModelVersion = builder.protectiveEquipmentModelVersion;
        this.persons = builder.persons;
        this.summary = builder.summary;
    }

    public final String protectiveEquipmentModelVersion() {
        return this.protectiveEquipmentModelVersion;
    }

    public final boolean hasPersons() {
        return this.persons != null && !(this.persons instanceof SdkAutoConstructList);
    }

    public final List<ProtectiveEquipmentPerson> persons() {
        return this.persons;
    }

    public final ProtectiveEquipmentSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectiveEquipmentModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersons() ? this.persons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProtectiveEquipmentResponse)) {
            return false;
        }
        DetectProtectiveEquipmentResponse other = (DetectProtectiveEquipmentResponse)((Object)obj);
        return Objects.equals(this.protectiveEquipmentModelVersion(), other.protectiveEquipmentModelVersion()) && this.hasPersons() == other.hasPersons() && Objects.equals(this.persons(), other.persons()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"DetectProtectiveEquipmentResponse").add("ProtectiveEquipmentModelVersion", (Object)this.protectiveEquipmentModelVersion()).add("Persons", this.hasPersons() ? this.persons() : null).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectiveEquipmentModelVersion": {
                return Optional.ofNullable(clazz.cast(this.protectiveEquipmentModelVersion()));
            }
            case "Persons": {
                return Optional.ofNullable(clazz.cast(this.persons()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectiveEquipmentModelVersion", PROTECTIVE_EQUIPMENT_MODEL_VERSION_FIELD);
        map.put("Persons", PERSONS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectProtectiveEquipmentResponse, T> g) {
        return obj -> g.apply((DetectProtectiveEquipmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String protectiveEquipmentModelVersion;
        private List<ProtectiveEquipmentPerson> persons = DefaultSdkAutoConstructList.getInstance();
        private ProtectiveEquipmentSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProtectiveEquipmentResponse model) {
            super(model);
            this.protectiveEquipmentModelVersion(model.protectiveEquipmentModelVersion);
            this.persons(model.persons);
            this.summary(model.summary);
        }

        public final String getProtectiveEquipmentModelVersion() {
            return this.protectiveEquipmentModelVersion;
        }

        public final void setProtectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
            this.protectiveEquipmentModelVersion = protectiveEquipmentModelVersion;
        }

        @Override
        public final Builder protectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
            this.protectiveEquipmentModelVersion = protectiveEquipmentModelVersion;
            return this;
        }

        public final List<ProtectiveEquipmentPerson.Builder> getPersons() {
            List<ProtectiveEquipmentPerson.Builder> result = ProtectiveEquipmentPersonsCopier.copyToBuilder(this.persons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersons(Collection<ProtectiveEquipmentPerson.BuilderImpl> persons) {
            this.persons = ProtectiveEquipmentPersonsCopier.copyFromBuilder(persons);
        }

        @Override
        public final Builder persons(Collection<ProtectiveEquipmentPerson> persons) {
            this.persons = ProtectiveEquipmentPersonsCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(ProtectiveEquipmentPerson ... persons) {
            this.persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<ProtectiveEquipmentPerson.Builder> ... persons) {
            this.persons(Stream.of(persons).map(c -> (ProtectiveEquipmentPerson)((ProtectiveEquipmentPerson.Builder)ProtectiveEquipmentPerson.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProtectiveEquipmentSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(ProtectiveEquipmentSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(ProtectiveEquipmentSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public DetectProtectiveEquipmentResponse build() {
            return new DetectProtectiveEquipmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectProtectiveEquipmentResponse> {
        public Builder protectiveEquipmentModelVersion(String var1);

        public Builder persons(Collection<ProtectiveEquipmentPerson> var1);

        public Builder persons(ProtectiveEquipmentPerson ... var1);

        public Builder persons(Consumer<ProtectiveEquipmentPerson.Builder> ... var1);

        public Builder summary(ProtectiveEquipmentSummary var1);

        default public Builder summary(Consumer<ProtectiveEquipmentSummary.Builder> summary) {
            return this.summary((ProtectiveEquipmentSummary)((ProtectiveEquipmentSummary.Builder)ProtectiveEquipmentSummary.builder().applyMutation(summary)).build());
        }
    }
}

