/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RegionOfInterest;
import software.amazon.awssdk.services.rekognition.model.RegionsOfInterestCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorDataSharingPreference;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorInput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamProcessorResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeStreamProcessorResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::name)).setter(DescribeStreamProcessorResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STREAM_PROCESSOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamProcessorArn").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::streamProcessorArn)).setter(DescribeStreamProcessorResponse.setter(Builder::streamProcessorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessorArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::statusAsString)).setter(DescribeStreamProcessorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::statusMessage)).setter(DescribeStreamProcessorResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::creationTimestamp)).setter(DescribeStreamProcessorResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::lastUpdateTimestamp)).setter(DescribeStreamProcessorResponse.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::input)).setter(DescribeStreamProcessorResponse.setter(Builder::input)).constructor(StreamProcessorInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::output)).setter(DescribeStreamProcessorResponse.setter(Builder::output)).constructor(StreamProcessorOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::roleArn)).setter(DescribeStreamProcessorResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::settings)).setter(DescribeStreamProcessorResponse.setter(Builder::settings)).constructor(StreamProcessorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<StreamProcessorNotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::notificationChannel)).setter(DescribeStreamProcessorResponse.setter(Builder::notificationChannel)).constructor(StreamProcessorNotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::kmsKeyId)).setter(DescribeStreamProcessorResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionsOfInterest").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::regionsOfInterest)).setter(DescribeStreamProcessorResponse.setter(Builder::regionsOfInterest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamProcessorDataSharingPreference> DATA_SHARING_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSharingPreference").getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::dataSharingPreference)).setter(DescribeStreamProcessorResponse.setter(Builder::dataSharingPreference)).constructor(StreamProcessorDataSharingPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSharingPreference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STREAM_PROCESSOR_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, INPUT_FIELD, OUTPUT_FIELD, ROLE_ARN_FIELD, SETTINGS_FIELD, NOTIFICATION_CHANNEL_FIELD, KMS_KEY_ID_FIELD, REGIONS_OF_INTEREST_FIELD, DATA_SHARING_PREFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStreamProcessorResponse.memberNameToFieldInitializer();
    private final String name;
    private final String streamProcessorArn;
    private final String status;
    private final String statusMessage;
    private final Instant creationTimestamp;
    private final Instant lastUpdateTimestamp;
    private final StreamProcessorInput input;
    private final StreamProcessorOutput output;
    private final String roleArn;
    private final StreamProcessorSettings settings;
    private final StreamProcessorNotificationChannel notificationChannel;
    private final String kmsKeyId;
    private final List<RegionOfInterest> regionsOfInterest;
    private final StreamProcessorDataSharingPreference dataSharingPreference;

    private DescribeStreamProcessorResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.streamProcessorArn = builder.streamProcessorArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.input = builder.input;
        this.output = builder.output;
        this.roleArn = builder.roleArn;
        this.settings = builder.settings;
        this.notificationChannel = builder.notificationChannel;
        this.kmsKeyId = builder.kmsKeyId;
        this.regionsOfInterest = builder.regionsOfInterest;
        this.dataSharingPreference = builder.dataSharingPreference;
    }

    public final String name() {
        return this.name;
    }

    public final String streamProcessorArn() {
        return this.streamProcessorArn;
    }

    public final StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final StreamProcessorInput input() {
        return this.input;
    }

    public final StreamProcessorOutput output() {
        return this.output;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final StreamProcessorSettings settings() {
        return this.settings;
    }

    public final StreamProcessorNotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasRegionsOfInterest() {
        return this.regionsOfInterest != null && !(this.regionsOfInterest instanceof SdkAutoConstructList);
    }

    public final List<RegionOfInterest> regionsOfInterest() {
        return this.regionsOfInterest;
    }

    public final StreamProcessorDataSharingPreference dataSharingPreference() {
        return this.dataSharingPreference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamProcessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionsOfInterest() ? this.regionsOfInterest() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSharingPreference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamProcessorResponse)) {
            return false;
        }
        DescribeStreamProcessorResponse other = (DescribeStreamProcessorResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.streamProcessorArn(), other.streamProcessorArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasRegionsOfInterest() == other.hasRegionsOfInterest() && Objects.equals(this.regionsOfInterest(), other.regionsOfInterest()) && Objects.equals(this.dataSharingPreference(), other.dataSharingPreference());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStreamProcessorResponse").add("Name", (Object)this.name()).add("StreamProcessorArn", (Object)this.streamProcessorArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("Input", (Object)this.input()).add("Output", (Object)this.output()).add("RoleArn", (Object)this.roleArn()).add("Settings", (Object)this.settings()).add("NotificationChannel", (Object)this.notificationChannel()).add("KmsKeyId", (Object)this.kmsKeyId()).add("RegionsOfInterest", this.hasRegionsOfInterest() ? this.regionsOfInterest() : null).add("DataSharingPreference", (Object)this.dataSharingPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StreamProcessorArn": {
                return Optional.ofNullable(clazz.cast(this.streamProcessorArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "RegionsOfInterest": {
                return Optional.ofNullable(clazz.cast(this.regionsOfInterest()));
            }
            case "DataSharingPreference": {
                return Optional.ofNullable(clazz.cast(this.dataSharingPreference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("StreamProcessorArn", STREAM_PROCESSOR_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("RegionsOfInterest", REGIONS_OF_INTEREST_FIELD);
        map.put("DataSharingPreference", DATA_SHARING_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamProcessorResponse, T> g) {
        return obj -> g.apply((DescribeStreamProcessorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String name;
        private String streamProcessorArn;
        private String status;
        private String statusMessage;
        private Instant creationTimestamp;
        private Instant lastUpdateTimestamp;
        private StreamProcessorInput input;
        private StreamProcessorOutput output;
        private String roleArn;
        private StreamProcessorSettings settings;
        private StreamProcessorNotificationChannel notificationChannel;
        private String kmsKeyId;
        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();
        private StreamProcessorDataSharingPreference dataSharingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamProcessorResponse model) {
            super(model);
            this.name(model.name);
            this.streamProcessorArn(model.streamProcessorArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.input(model.input);
            this.output(model.output);
            this.roleArn(model.roleArn);
            this.settings(model.settings);
            this.notificationChannel(model.notificationChannel);
            this.kmsKeyId(model.kmsKeyId);
            this.regionsOfInterest(model.regionsOfInterest);
            this.dataSharingPreference(model.dataSharingPreference);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStreamProcessorArn() {
            return this.streamProcessorArn;
        }

        public final void setStreamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
        }

        @Override
        public final Builder streamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final StreamProcessorInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final StreamProcessorNotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(StreamProcessorNotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(StreamProcessorNotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterest() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        @Override
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest ... regionsOfInterest) {
            this.regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... regionsOfInterest) {
            this.regionsOfInterest(Stream.of(regionsOfInterest).map(c -> (RegionOfInterest)((RegionOfInterest.Builder)RegionOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamProcessorDataSharingPreference.Builder getDataSharingPreference() {
            return this.dataSharingPreference != null ? this.dataSharingPreference.toBuilder() : null;
        }

        public final void setDataSharingPreference(StreamProcessorDataSharingPreference.BuilderImpl dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference != null ? dataSharingPreference.build() : null;
        }

        @Override
        public final Builder dataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference;
            return this;
        }

        @Override
        public DescribeStreamProcessorResponse build() {
            return new DescribeStreamProcessorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamProcessorResponse> {
        public Builder name(String var1);

        public Builder streamProcessorArn(String var1);

        public Builder status(String var1);

        public Builder status(StreamProcessorStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder input(StreamProcessorInput var1);

        default public Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return this.input((StreamProcessorInput)((StreamProcessorInput.Builder)StreamProcessorInput.builder().applyMutation(input)).build());
        }

        public Builder output(StreamProcessorOutput var1);

        default public Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return this.output((StreamProcessorOutput)((StreamProcessorOutput.Builder)StreamProcessorOutput.builder().applyMutation(output)).build());
        }

        public Builder roleArn(String var1);

        public Builder settings(StreamProcessorSettings var1);

        default public Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return this.settings((StreamProcessorSettings)((StreamProcessorSettings.Builder)StreamProcessorSettings.builder().applyMutation(settings)).build());
        }

        public Builder notificationChannel(StreamProcessorNotificationChannel var1);

        default public Builder notificationChannel(Consumer<StreamProcessorNotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((StreamProcessorNotificationChannel)((StreamProcessorNotificationChannel.Builder)StreamProcessorNotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder regionsOfInterest(Collection<RegionOfInterest> var1);

        public Builder regionsOfInterest(RegionOfInterest ... var1);

        public Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... var1);

        public Builder dataSharingPreference(StreamProcessorDataSharingPreference var1);

        default public Builder dataSharingPreference(Consumer<StreamProcessorDataSharingPreference.Builder> dataSharingPreference) {
            return this.dataSharingPreference((StreamProcessorDataSharingPreference)((StreamProcessorDataSharingPreference.Builder)StreamProcessorDataSharingPreference.builder().applyMutation(dataSharingPreference)).build());
        }
    }
}

