/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.QualityFilter;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUsersByImageRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchUsersByImageRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(SearchUsersByImageRequest.getter(SearchUsersByImageRequest::collectionId)).setter(SearchUsersByImageRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(SearchUsersByImageRequest.getter(SearchUsersByImageRequest::image)).setter(SearchUsersByImageRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Float> USER_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("UserMatchThreshold").getter(SearchUsersByImageRequest.getter(SearchUsersByImageRequest::userMatchThreshold)).setter(SearchUsersByImageRequest.setter(Builder::userMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatchThreshold").build()}).build();
    private static final SdkField<Integer> MAX_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUsers").getter(SearchUsersByImageRequest.getter(SearchUsersByImageRequest::maxUsers)).setter(SearchUsersByImageRequest.setter(Builder::maxUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUsers").build()}).build();
    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityFilter").getter(SearchUsersByImageRequest.getter(SearchUsersByImageRequest::qualityFilterAsString)).setter(SearchUsersByImageRequest.setter(Builder::qualityFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, IMAGE_FIELD, USER_MATCH_THRESHOLD_FIELD, MAX_USERS_FIELD, QUALITY_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchUsersByImageRequest.memberNameToFieldInitializer();
    private final String collectionId;
    private final Image image;
    private final Float userMatchThreshold;
    private final Integer maxUsers;
    private final String qualityFilter;

    private SearchUsersByImageRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.userMatchThreshold = builder.userMatchThreshold;
        this.maxUsers = builder.maxUsers;
        this.qualityFilter = builder.qualityFilter;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final Image image() {
        return this.image;
    }

    public final Float userMatchThreshold() {
        return this.userMatchThreshold;
    }

    public final Integer maxUsers() {
        return this.maxUsers;
    }

    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(this.qualityFilter);
    }

    public final String qualityFilterAsString() {
        return this.qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersByImageRequest)) {
            return false;
        }
        SearchUsersByImageRequest other = (SearchUsersByImageRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.userMatchThreshold(), other.userMatchThreshold()) && Objects.equals(this.maxUsers(), other.maxUsers()) && Objects.equals(this.qualityFilterAsString(), other.qualityFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUsersByImageRequest").add("CollectionId", (Object)this.collectionId()).add("Image", (Object)this.image()).add("UserMatchThreshold", (Object)this.userMatchThreshold()).add("MaxUsers", (Object)this.maxUsers()).add("QualityFilter", (Object)this.qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "UserMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.userMatchThreshold()));
            }
            case "MaxUsers": {
                return Optional.ofNullable(clazz.cast(this.maxUsers()));
            }
            case "QualityFilter": {
                return Optional.ofNullable(clazz.cast(this.qualityFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("UserMatchThreshold", USER_MATCH_THRESHOLD_FIELD);
        map.put("MaxUsers", MAX_USERS_FIELD);
        map.put("QualityFilter", QUALITY_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersByImageRequest, T> g) {
        return obj -> g.apply((SearchUsersByImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private Float userMatchThreshold;
        private Integer maxUsers;
        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersByImageRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.userMatchThreshold(model.userMatchThreshold);
            this.maxUsers(model.maxUsers);
            this.qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Float getUserMatchThreshold() {
            return this.userMatchThreshold;
        }

        public final void setUserMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
        }

        @Override
        public final Builder userMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
            return this;
        }

        public final Integer getMaxUsers() {
            return this.maxUsers;
        }

        public final void setMaxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
        }

        @Override
        public final Builder maxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public final String getQualityFilter() {
            return this.qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUsersByImageRequest build() {
            return new SearchUsersByImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUsersByImageRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder userMatchThreshold(Float var1);

        public Builder maxUsers(Integer var1);

        public Builder qualityFilter(String var1);

        public Builder qualityFilter(QualityFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

