/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ChallengePreference;
import software.amazon.awssdk.services.rekognition.model.ChallengePreferencesCopier;
import software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFaceLivenessSessionRequestSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFaceLivenessSessionRequestSettings> {
    private static final SdkField<LivenessOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateFaceLivenessSessionRequestSettings.getter(CreateFaceLivenessSessionRequestSettings::outputConfig)).setter(CreateFaceLivenessSessionRequestSettings.setter(Builder::outputConfig)).constructor(LivenessOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<Integer> AUDIT_IMAGES_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AuditImagesLimit").getter(CreateFaceLivenessSessionRequestSettings.getter(CreateFaceLivenessSessionRequestSettings::auditImagesLimit)).setter(CreateFaceLivenessSessionRequestSettings.setter(Builder::auditImagesLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditImagesLimit").build()}).build();
    private static final SdkField<List<ChallengePreference>> CHALLENGE_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChallengePreferences").getter(CreateFaceLivenessSessionRequestSettings.getter(CreateFaceLivenessSessionRequestSettings::challengePreferences)).setter(CreateFaceLivenessSessionRequestSettings.setter(Builder::challengePreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengePreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChallengePreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_CONFIG_FIELD, AUDIT_IMAGES_LIMIT_FIELD, CHALLENGE_PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFaceLivenessSessionRequestSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LivenessOutputConfig outputConfig;
    private final Integer auditImagesLimit;
    private final List<ChallengePreference> challengePreferences;

    private CreateFaceLivenessSessionRequestSettings(BuilderImpl builder) {
        this.outputConfig = builder.outputConfig;
        this.auditImagesLimit = builder.auditImagesLimit;
        this.challengePreferences = builder.challengePreferences;
    }

    public final LivenessOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final Integer auditImagesLimit() {
        return this.auditImagesLimit;
    }

    public final boolean hasChallengePreferences() {
        return this.challengePreferences != null && !(this.challengePreferences instanceof SdkAutoConstructList);
    }

    public final List<ChallengePreference> challengePreferences() {
        return this.challengePreferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditImagesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChallengePreferences() ? this.challengePreferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFaceLivenessSessionRequestSettings)) {
            return false;
        }
        CreateFaceLivenessSessionRequestSettings other = (CreateFaceLivenessSessionRequestSettings)obj;
        return Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.auditImagesLimit(), other.auditImagesLimit()) && this.hasChallengePreferences() == other.hasChallengePreferences() && Objects.equals(this.challengePreferences(), other.challengePreferences());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFaceLivenessSessionRequestSettings").add("OutputConfig", (Object)this.outputConfig()).add("AuditImagesLimit", (Object)this.auditImagesLimit()).add("ChallengePreferences", this.hasChallengePreferences() ? this.challengePreferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "AuditImagesLimit": {
                return Optional.ofNullable(clazz.cast(this.auditImagesLimit()));
            }
            case "ChallengePreferences": {
                return Optional.ofNullable(clazz.cast(this.challengePreferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("AuditImagesLimit", AUDIT_IMAGES_LIMIT_FIELD);
        map.put("ChallengePreferences", CHALLENGE_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFaceLivenessSessionRequestSettings, T> g) {
        return obj -> g.apply((CreateFaceLivenessSessionRequestSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LivenessOutputConfig outputConfig;
        private Integer auditImagesLimit;
        private List<ChallengePreference> challengePreferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFaceLivenessSessionRequestSettings model) {
            this.outputConfig(model.outputConfig);
            this.auditImagesLimit(model.auditImagesLimit);
            this.challengePreferences(model.challengePreferences);
        }

        public final LivenessOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(LivenessOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(LivenessOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Integer getAuditImagesLimit() {
            return this.auditImagesLimit;
        }

        public final void setAuditImagesLimit(Integer auditImagesLimit) {
            this.auditImagesLimit = auditImagesLimit;
        }

        @Override
        public final Builder auditImagesLimit(Integer auditImagesLimit) {
            this.auditImagesLimit = auditImagesLimit;
            return this;
        }

        public final List<ChallengePreference.Builder> getChallengePreferences() {
            List<ChallengePreference.Builder> result = ChallengePreferencesCopier.copyToBuilder(this.challengePreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChallengePreferences(Collection<ChallengePreference.BuilderImpl> challengePreferences) {
            this.challengePreferences = ChallengePreferencesCopier.copyFromBuilder(challengePreferences);
        }

        @Override
        public final Builder challengePreferences(Collection<ChallengePreference> challengePreferences) {
            this.challengePreferences = ChallengePreferencesCopier.copy(challengePreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengePreferences(ChallengePreference ... challengePreferences) {
            this.challengePreferences(Arrays.asList(challengePreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengePreferences(Consumer<ChallengePreference.Builder> ... challengePreferences) {
            this.challengePreferences(Stream.of(challengePreferences).map(c -> (ChallengePreference)((ChallengePreference.Builder)ChallengePreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateFaceLivenessSessionRequestSettings build() {
            return new CreateFaceLivenessSessionRequestSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFaceLivenessSessionRequestSettings> {
        public Builder outputConfig(LivenessOutputConfig var1);

        default public Builder outputConfig(Consumer<LivenessOutputConfig.Builder> outputConfig) {
            return this.outputConfig((LivenessOutputConfig)((LivenessOutputConfig.Builder)LivenessOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder auditImagesLimit(Integer var1);

        public Builder challengePreferences(Collection<ChallengePreference> var1);

        public Builder challengePreferences(ChallengePreference ... var1);

        public Builder challengePreferences(Consumer<ChallengePreference.Builder> ... var1);
    }
}

