/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(SearchFacesRequest.getter(SearchFacesRequest::collectionId)).setter(SearchFacesRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<String> FACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceId").getter(SearchFacesRequest.getter(SearchFacesRequest::faceId)).setter(SearchFacesRequest.setter(Builder::faceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()}).build();
    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFaces").getter(SearchFacesRequest.getter(SearchFacesRequest::maxFaces)).setter(SearchFacesRequest.setter(Builder::maxFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()}).build();
    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FaceMatchThreshold").getter(SearchFacesRequest.getter(SearchFacesRequest::faceMatchThreshold)).setter(SearchFacesRequest.setter(Builder::faceMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, FACE_ID_FIELD, MAX_FACES_FIELD, FACE_MATCH_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchFacesRequest.memberNameToFieldInitializer();
    private final String collectionId;
    private final String faceId;
    private final Integer maxFaces;
    private final Float faceMatchThreshold;

    private SearchFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.faceId = builder.faceId;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final String faceId() {
        return this.faceId;
    }

    public final Integer maxFaces() {
        return this.maxFaces;
    }

    public final Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesRequest)) {
            return false;
        }
        SearchFacesRequest other = (SearchFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.maxFaces(), other.maxFaces()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"SearchFacesRequest").add("CollectionId", (Object)this.collectionId()).add("FaceId", (Object)this.faceId()).add("MaxFaces", (Object)this.maxFaces()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "FaceId": {
                return Optional.ofNullable(clazz.cast(this.faceId()));
            }
            case "MaxFaces": {
                return Optional.ofNullable(clazz.cast(this.maxFaces()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("FaceId", FACE_ID_FIELD);
        map.put("MaxFaces", MAX_FACES_FIELD);
        map.put("FaceMatchThreshold", FACE_MATCH_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesRequest, T> g) {
        return obj -> g.apply((SearchFacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private String faceId;
        private Integer maxFaces;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.faceId(model.faceId);
            this.maxFaces(model.maxFaces);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getFaceId() {
            return this.faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesRequest build() {
            return new SearchFacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchFacesRequest> {
        public Builder collectionId(String var1);

        public Builder faceId(String var1);

        public Builder maxFaces(Integer var1);

        public Builder faceMatchThreshold(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

