/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Attribute;
import software.amazon.awssdk.services.rekognition.model.AttributesCopier;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.QualityFilter;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, IndexFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(IndexFacesRequest.getter(IndexFacesRequest::collectionId)).setter(IndexFacesRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(IndexFacesRequest.getter(IndexFacesRequest::image)).setter(IndexFacesRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<String> EXTERNAL_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalImageId").getter(IndexFacesRequest.getter(IndexFacesRequest::externalImageId)).setter(IndexFacesRequest.setter(Builder::externalImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalImageId").build()}).build();
    private static final SdkField<List<String>> DETECTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DetectionAttributes").getter(IndexFacesRequest.getter(IndexFacesRequest::detectionAttributesAsStrings)).setter(IndexFacesRequest.setter(Builder::detectionAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFaces").getter(IndexFacesRequest.getter(IndexFacesRequest::maxFaces)).setter(IndexFacesRequest.setter(Builder::maxFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()}).build();
    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityFilter").getter(IndexFacesRequest.getter(IndexFacesRequest::qualityFilterAsString)).setter(IndexFacesRequest.setter(Builder::qualityFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, IMAGE_FIELD, EXTERNAL_IMAGE_ID_FIELD, DETECTION_ATTRIBUTES_FIELD, MAX_FACES_FIELD, QUALITY_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexFacesRequest.memberNameToFieldInitializer();
    private final String collectionId;
    private final Image image;
    private final String externalImageId;
    private final List<String> detectionAttributes;
    private final Integer maxFaces;
    private final String qualityFilter;

    private IndexFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
        this.maxFaces = builder.maxFaces;
        this.qualityFilter = builder.qualityFilter;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final Image image() {
        return this.image;
    }

    public final String externalImageId() {
        return this.externalImageId;
    }

    public final List<Attribute> detectionAttributes() {
        return AttributesCopier.copyStringToEnum(this.detectionAttributes);
    }

    public final boolean hasDetectionAttributes() {
        return this.detectionAttributes != null && !(this.detectionAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> detectionAttributesAsStrings() {
        return this.detectionAttributes;
    }

    public final Integer maxFaces() {
        return this.maxFaces;
    }

    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(this.qualityFilter);
    }

    public final String qualityFilterAsString() {
        return this.qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectionAttributes() ? this.detectionAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.externalImageId(), other.externalImageId()) && this.hasDetectionAttributes() == other.hasDetectionAttributes() && Objects.equals(this.detectionAttributesAsStrings(), other.detectionAttributesAsStrings()) && Objects.equals(this.maxFaces(), other.maxFaces()) && Objects.equals(this.qualityFilterAsString(), other.qualityFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IndexFacesRequest").add("CollectionId", (Object)this.collectionId()).add("Image", (Object)this.image()).add("ExternalImageId", (Object)this.externalImageId()).add("DetectionAttributes", this.hasDetectionAttributes() ? this.detectionAttributesAsStrings() : null).add("MaxFaces", (Object)this.maxFaces()).add("QualityFilter", (Object)this.qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ExternalImageId": {
                return Optional.ofNullable(clazz.cast(this.externalImageId()));
            }
            case "DetectionAttributes": {
                return Optional.ofNullable(clazz.cast(this.detectionAttributesAsStrings()));
            }
            case "MaxFaces": {
                return Optional.ofNullable(clazz.cast(this.maxFaces()));
            }
            case "QualityFilter": {
                return Optional.ofNullable(clazz.cast(this.qualityFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("ExternalImageId", EXTERNAL_IMAGE_ID_FIELD);
        map.put("DetectionAttributes", DETECTION_ATTRIBUTES_FIELD);
        map.put("MaxFaces", MAX_FACES_FIELD);
        map.put("QualityFilter", QUALITY_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexFacesRequest, T> g) {
        return obj -> g.apply((IndexFacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private String externalImageId;
        private List<String> detectionAttributes = DefaultSdkAutoConstructList.getInstance();
        private Integer maxFaces;
        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.externalImageId(model.externalImageId);
            this.detectionAttributesWithStrings(model.detectionAttributes);
            this.maxFaces(model.maxFaces);
            this.qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final Collection<String> getDetectionAttributes() {
            if (this.detectionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectionAttributes;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @Override
        public final Builder detectionAttributesWithStrings(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributesWithStrings(String ... detectionAttributes) {
            this.detectionAttributesWithStrings(Arrays.asList(detectionAttributes));
            return this;
        }

        @Override
        public final Builder detectionAttributes(Collection<Attribute> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copyEnumToString(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(Attribute ... detectionAttributes) {
            this.detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final String getQualityFilter() {
            return this.qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IndexFacesRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder externalImageId(String var1);

        public Builder detectionAttributesWithStrings(Collection<String> var1);

        public Builder detectionAttributesWithStrings(String ... var1);

        public Builder detectionAttributes(Collection<Attribute> var1);

        public Builder detectionAttributes(Attribute ... var1);

        public Builder maxFaces(Integer var1);

        public Builder qualityFilter(String var1);

        public Builder qualityFilter(QualityFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

