/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.HumanLoopConfig;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectModerationLabelsRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectModerationLabelsRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DetectModerationLabelsRequest.getter(DetectModerationLabelsRequest::image)).setter(DetectModerationLabelsRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(DetectModerationLabelsRequest.getter(DetectModerationLabelsRequest::minConfidence)).setter(DetectModerationLabelsRequest.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopConfig").getter(DetectModerationLabelsRequest.getter(DetectModerationLabelsRequest::humanLoopConfig)).setter(DetectModerationLabelsRequest.setter(Builder::humanLoopConfig)).constructor(HumanLoopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()}).build();
    private static final SdkField<String> PROJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersion").getter(DetectModerationLabelsRequest.getter(DetectModerationLabelsRequest::projectVersion)).setter(DetectModerationLabelsRequest.setter(Builder::projectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, MIN_CONFIDENCE_FIELD, HUMAN_LOOP_CONFIG_FIELD, PROJECT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectModerationLabelsRequest.memberNameToFieldInitializer();
    private final Image image;
    private final Float minConfidence;
    private final HumanLoopConfig humanLoopConfig;
    private final String projectVersion;

    private DetectModerationLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.minConfidence = builder.minConfidence;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.projectVersion = builder.projectVersion;
    }

    public final Image image() {
        return this.image;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public final HumanLoopConfig humanLoopConfig() {
        return this.humanLoopConfig;
    }

    public final String projectVersion() {
        return this.projectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsRequest)) {
            return false;
        }
        DetectModerationLabelsRequest other = (DetectModerationLabelsRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.humanLoopConfig(), other.humanLoopConfig()) && Objects.equals(this.projectVersion(), other.projectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DetectModerationLabelsRequest").add("Image", (Object)this.image()).add("MinConfidence", (Object)this.minConfidence()).add("HumanLoopConfig", (Object)this.humanLoopConfig()).add("ProjectVersion", (Object)this.projectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "HumanLoopConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopConfig()));
            }
            case "ProjectVersion": {
                return Optional.ofNullable(clazz.cast(this.projectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Image", IMAGE_FIELD);
        map.put("MinConfidence", MIN_CONFIDENCE_FIELD);
        map.put("HumanLoopConfig", HUMAN_LOOP_CONFIG_FIELD);
        map.put("ProjectVersion", PROJECT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectModerationLabelsRequest, T> g) {
        return obj -> g.apply((DetectModerationLabelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private Float minConfidence;
        private HumanLoopConfig humanLoopConfig;
        private String projectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsRequest model) {
            super(model);
            this.image(model.image);
            this.minConfidence(model.minConfidence);
            this.humanLoopConfig(model.humanLoopConfig);
            this.projectVersion(model.projectVersion);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return this.humanLoopConfig != null ? this.humanLoopConfig.toBuilder() : null;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final String getProjectVersion() {
            return this.projectVersion;
        }

        public final void setProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
        }

        @Override
        public final Builder projectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectModerationLabelsRequest build() {
            return new DetectModerationLabelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectModerationLabelsRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder minConfidence(Float var1);

        public Builder humanLoopConfig(HumanLoopConfig var1);

        default public Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return this.humanLoopConfig((HumanLoopConfig)((HumanLoopConfig.Builder)HumanLoopConfig.builder().applyMutation(humanLoopConfig)).build());
        }

        public Builder projectVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

