/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsRequest;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsResponse;

public class ListMediaAnalysisJobsIterable
implements SdkIterable<ListMediaAnalysisJobsResponse> {
    private final RekognitionClient client;
    private final ListMediaAnalysisJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMediaAnalysisJobsIterable(RekognitionClient client, ListMediaAnalysisJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMediaAnalysisJobsResponseFetcher();
    }

    public Iterator<ListMediaAnalysisJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMediaAnalysisJobsResponseFetcher
    implements SyncPageFetcher<ListMediaAnalysisJobsResponse> {
        private ListMediaAnalysisJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaAnalysisJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMediaAnalysisJobsResponse nextPage(ListMediaAnalysisJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMediaAnalysisJobsIterable.this.client.listMediaAnalysisJobs(ListMediaAnalysisJobsIterable.this.firstRequest);
            }
            return ListMediaAnalysisJobsIterable.this.client.listMediaAnalysisJobs((ListMediaAnalysisJobsRequest)((Object)ListMediaAnalysisJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

